<?php

    $colleges = App\Models\College::orderBy('id', 'desc')
        ->where('delete_status', '0')
        ->get();
    $courses = App\Models\Course::orderBy('id', 'desc')
        ->where('delete_status', '0')
        ->take('10')
        ->get();
    $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')
        ->where('delete_status', '0')
        ->first();

?>


</div><!-- site-main end-->

<!-- footer start -->
<footer class="footer widget-footer clearfix">
    <div class="second-footer prt-bgimage-yes bg-footer prt-bg bg-base-dark">
        <div class="prt-row-wrapper-bg-layer prt-bg-layer"></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widgte-text">
                            <img src="<?php echo e($setup ? asset('../backend/images/website/' . $setup->footer_logo) : ''); ?>" width="250" alt="Logo"
                                onerror="this.src='<?php echo e(asset('frontend/images/footer-logo.png')); ?>';this.onerror='';">
                            <hr>
                            <?php echo $setup ? $setup->about_footer : ''; ?>

                        </div>
                        <div class="widget_social">
                            <div class="social-icons social-hover">
                                <ul class="social-icons d-flex">
                                    <li>
                                        <a class="prt-social-instagram" href="<?php echo e($setup ? $setup->instagram_link : ''); ?>"
                                            target="_blank"><i class="icon-instagram"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-facebook" href="<?php echo e($setup ? $setup->facebook_link : ''); ?>"
                                            target="_blank"><i class="icon-facebook"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-twitter" href="<?php echo e($setup ? $setup->twitter_link : ''); ?>"
                                            target="_blank"><i class="icon-twitter"></i></a>
                                    </li>

                                    <li>
                                        <a class="prt-social-linkedin" href="<?php echo e($setup ? $setup->linkedin_link : ''); ?>"
                                            target="_blank"><i class="icon-linkedin"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-youtube" href="<?php echo e($setup ? $setup->youtube_link : ''); ?>"
                                            target="_blank"><i class="icon-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Business Registration</h3>
                            </div>
                            <ul class="menu-footer-quick-links">
                                <li><a href="<?php echo e(route('registration','proprietorship-registration')); ?>">Proprietorship Registration</a></li>
                                <li><a href="<?php echo e(route('registration','partnership-registration')); ?>">Partnership Registration </a></li>
                                <li><a href="<?php echo e(route('registration','one-person-company')); ?>">One Person Company </a></li>
                                <li><a href="<?php echo e(route('registration','pvt-ltd-company')); ?>">Pvt Ltd Company  </a></li>
                                <li><a href="<?php echo e(route('registration','public-ltd-company')); ?>">Public Ltd Company </a></li>
                                <li><a href="<?php echo e(route('registration','nidhi-company')); ?>">Nidhi Company </a></li>
                                <li><a href="<?php echo e(route('registration','section-8-company')); ?>">Section 8 Company</a></li>
                                <li><a href="<?php echo e(route('registration','producer-company')); ?>">Producer Company</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Registration GST</h3>
                            </div>

                            <ul class="menu-footer-quick-links">
                                <li><a href="<?php echo e(route('registration','gst-registations')); ?>">GST Registrations</a></li>
                                <li><a href="<?php echo e(route('registration','gst-return-filing')); ?>">GST Return Filing</a></li>
                                <li><a href="<?php echo e(route('registration','gst-registration-cancellation')); ?>">GST Registration Cancellation</a></li>
                                <li><a href="<?php echo e(route('registration','activation-of-suspended-gst')); ?>">Activation of Suspended GST</a></li>
                                <li><a href="<?php echo e(route('registration','gst-lut-Filings')); ?>">GST LUT Filings (Letter of Undertaking)</a></li>
                                <li><a href="<?php echo e(route('registration','change-of-principal-address')); ?>">Change of Principal Address</a></li>
                                <li><a href="<?php echo e(route('registration','addition-of-additional-place-of-business')); ?>">Addition of Additional Place of Business</a></li>
                                <li><a href="<?php echo e(route('registration','change-of-business-name')); ?>">Change of Business Name</a></li>
                            </ul>

                        </div>

                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget-title">
                        <h3>Get In Touch</h3>
                    </div>
                    <div class="res-767-pb-18">
                        <p> <?php echo $setup ? $setup->contact_address : ''; ?></p>
                        <p><strong>Front Desk : </strong><a
                                href="tel:+91-<?php echo e($setup ? $setup->contact_phone_1 : ''); ?>">+91-<?php echo e($setup ? $setup->contact_phone_1 : ''); ?></a>,
                            <a href="tel:+91-<?php echo $setup ? $setup->contact_phone_2 : ''; ?>"><?php echo $setup ? $setup->contact_phone_2 : ''; ?></a></p>
                        <p><strong>Email : </strong> <a
                                href="mailto:<?php echo e($setup ? $setup->contact_email_1 : ''); ?>"><?php echo e($setup ? $setup->contact_email_1 : ''); ?></a>
                        </p>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="bottom-footer-text prt-bg copyright">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="text-left">
                        <span class="cpy-text"> © 2023 <a href="#" class=" font-weight-500">
                                <?php echo $setup ? $setup->copyright_text : ''; ?> </a> All Rights Reserved.</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer><!-- footer end -->

<!-- Start OnClick Modal -->
<div class="modal" id="myModal" data-bs-keyboard="false" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Consultation Now</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa fa-times"
                        aria-hidden="true"></i></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <form action="<?php echo e(route('contactform')); ?>" class="contact_form clearfix" method="post">
                        <?php echo csrf_field(); ?>
                        <?php if($message = Session::get('success')): ?>
                            <div class="alert alert-success">
                                <p><?php echo e($message); ?></p>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <form action="<?php echo e(route('contactform')); ?>" class="contact_form clearfix" method="post">
                                <?php echo csrf_field(); ?>
                                <?php if($message = Session::get('success')): ?>
                                    <div class="alert alert-success">
                                        <p><?php echo e($message); ?></p>
                                    </div>
                                <?php endif; ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" name="name" class="form-control"
                                            value="<?php echo e(old('name')); ?>" placeholder="Your Name *" required="">
                                        <?php if($errors->has('name')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="email" name="email" class="form-control"
                                            value="<?php echo e(old('email')); ?>" placeholder="Your Email *" required="">
                                        <?php if($errors->has('email')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('email')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="number" name="number" class="form-control"
                                            value="<?php echo e(old('number')); ?>" maxlength="10" pattern="[0-9]{10}"
                                            placeholder="Your Number *" required="">
                                        <?php if($errors->has('number')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('number')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="services" class="form-control"
                                            value="<?php echo e(old('services')); ?>" placeholder="Service You Need *"
                                            required="">
                                        <?php if($errors->has('services')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('services')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="city" class="form-control"
                                            value="<?php echo e(old('city')); ?>" placeholder="Your City *" required="">
                                        <?php if($errors->has('city')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('city')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="state" class="form-control"
                                            value="<?php echo e(old('state')); ?>" placeholder="Your State *" required="">
                                        <?php if($errors->has('state')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('state')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-12">
                                        <textarea name="message" class="form-control textarea" placeholder="Type Your Message Here . . ."><?php echo e(old('message')); ?></textarea>
                                    </div>
                                    <div class="mt-5 text-center">
                                        <button
                                            class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor"
                                            type="submit" value="submit">Submit Here <i
                                                class="fa fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- End OnClick Modal -->


<!-- back-to-top start -->
<a id="totop" href="#top">
    <i class="fa fa-angle-up"></i>
</a>
<!-- back-to-top end -->
<a href="tel:+91-7982452520" class="float1" target="_blank"> <i class="flaticon-phone-call my-float"></i> </a>
<a href="https://api.whatsapp.com/send?phone=917982452520&amp;text=ReturnPro" class="float" target="_blank">
    <i class="fa fa-whatsapp my-float"></i> </a>


</div><!-- page end -->
<!-- Javascript -->
<script src="<?php echo e(asset('frontend/js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-migrate-3.3.2.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/bootstrap.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/aos.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-validate.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.prettyPhoto.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-waypoints.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/numinate.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/imagesloaded.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-isotope.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.twentytwenty.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/circle-progress.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/main.js')); ?>"></script>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\returnpro_laravel\resources\views/frontend/layouts/footer.blade.php ENDPATH**/ ?>