<!DOCTYPE html>
<html lang="zxx">

<head>

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/animate.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/fonts/flaticon.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/boxicons.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/owl.theme.default.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/magnific-popup.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/nice-select.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/meanmenu.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/style.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/responsive.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/theme-dark.css')); ?>">
    <?php
        $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
    ?>
    <title><?php echo e(env('APP_NAME')); ?></title>
    <?php if(isset($setup->favicon)): ?>
        <link rel="icon" type="image/png" href="<?php echo e(asset('backend/images/website/' . $setup->favicon)); ?>">
    <?php endif; ?>
</head>

<body>

    <div class="preloader">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="spinner"></div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('frontend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if($setup && $setup->contact_phone_1): ?>
        <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>" class="float1" target="_blank"> <i
                class="bx bx-phone"></i> </a>
    <?php endif; ?>
    <?php if($setup && $setup->whatsapp_link): ?>
        <a href="https://api.whatsapp.com/send?phone=<?php echo e($setup->whatsapp_link); ?>&amp;text=<?php echo e(env('APP_NAME')); ?>"
            class="float" target="_blank">
            <i class="bx bxl-whatsapp"></i> </a>
    <?php endif; ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>