<!-- footer area -->
<footer class="footer-area">
    <div class="footer-widget">
        <div class="container">
            <div class="footer-widget-wrap pt-60 pb-50">
                <div class="row g-4">
                    <div class="col-lg-5">
                        <div class="footer-widget-box about-us">
                            <?php if(isset($setup->footer_logo)): ?>
                                <a href="<?php echo e(route('home')); ?>" class="footer-logo">
                                    <img src="<?php echo e(asset('backend/images/website/' . $setup->footer_logo)); ?>" alt="">
                                </a>
                            <?php endif; ?>
                            <span class="mb-4">
                                <?php echo $setup->about_footer; ?>

                            </span>
                        </div>
                        <ul class="footer-social">
                            <?php if(isset($setup->facebook_link)): ?>
                                <li><a href="<?php echo e($setup->facebook_link); ?>"><i class="fab fa-facebook-f"></i></a></li>
                            <?php endif; ?>
                            <?php if(isset($setup->twitter_link)): ?>
                                <li><a href="<?php echo e($setup->twitter_link); ?>"><i class="fab fa-x-twitter"></i></a></li>
                            <?php endif; ?>
                            <?php if(isset($setup->instagram_link)): ?>
                                <li><a href="<?php echo e($setup->instagram_link); ?>"><i class="fab fa-instagram"></i></a></li>
                            <?php endif; ?>
                            <?php if(isset($setup->linkedin_link)): ?>
                                <li><a href="<?php echo e($setup->linkedin_link); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                            <?php endif; ?>
                            <?php if(isset($setup->youtube_link)): ?>
                                <li><a href="<?php echo e($setup->youtube_link); ?>"><i class="fab fa-youtube"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="col-6 col-lg-2">
                        <div class="footer-widget-box list">
                            <h4 class="footer-widget-title">Company</h4>
                            <ul class="footer-list">
                                <li><a href="<?php echo e(route('about')); ?>"><i class="far fa-angle-double-right"></i>About Us</a>
                                </li>
                                <li><a href="<?php echo e(route('faq')); ?>"><i class="far fa-angle-double-right"></i>Faq</a>
                                </li>
                                <li><a href="<?php echo e(route('service')); ?>"><i
                                            class="far fa-angle-double-right"></i>Services</a>
                                </li>
                                <li><a href="<?php echo e(route('product')); ?>"><i
                                            class="far fa-angle-double-right"></i>Products</a>
                                </li>
                                <li><a href="<?php echo e(route('contact')); ?>"><i class="far fa-angle-double-right"></i>Contact
                                        Us</a>
                                </li>
                                <li><a href="#"><i class="far fa-angle-double-right"></i>Terms Of Service</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-6 col-lg-2">
                        <div class="footer-widget-box list">
                            <h4 class="footer-widget-title">Services</h4>
                            <?php
                                $services = App\Models\Services::where('delete_status', '0')
                                    ->where('status', '1')
                                    ->latest()
                                    ->take(6)
                                    ->get();
                            ?>
                            <ul class="footer-list">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('service')); ?>"><i
                                                class="far fa-angle-double-right"></i><?php echo e($service->title); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-widget-box">
                            <h4 class="footer-widget-title">Get In Touch</h4>
                            <ul class="footer-contact">
                                <?php if(isset($setup->contact_address)): ?>
                                <li>
                                    <div class="icon">
                                        <i class="far fa-location-dot"></i>
                                    </div>
                                    <div class="content">
                                        <h6>Our Address</h6>
                                        <p><?php echo e($setup->contact_address); ?></p>
                                    </div>
                                </li>
                                <?php endif; ?>
                                <?php if($setup->contact_phone_1 || $setup->contact_phone_2): ?>
                                    <li>
                                        <div class="icon">
                                            <i class="far fa-phone"></i>
                                        </div>
                                        <div class="content">
                                            <h6>Call Us</h6>
                                            <?php if(isset($setup->contact_phone_1)): ?>
                                                <a
                                                    href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a>
                                            <?php endif; ?>
                                            <?php if(isset($setup->contact_phone_2)): ?>
                                                <a
                                                    href="tel:+91-<?php echo e($setup->contact_phone_2); ?>">+91-<?php echo e($setup->contact_phone_2); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                <?php endif; ?>
                                <?php if($setup->contact_email_1 || $setup->contact_email_2): ?>
                                    <li>
                                        <div class="icon">
                                            <i class="far fa-envelope"></i>
                                        </div>
                                        <div class="content">
                                            <h6>Mail Us</h6>
                                            <?php if(isset($setup->contact_email_1)): ?>
                                                <a
                                                    href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a>
                                            <?php endif; ?>
                                            <?php if(isset($setup->contact_email_2)): ?>
                                                <a
                                                    href="mailto:<?php echo e($setup->contact_email_2); ?>"><?php echo e($setup->contact_email_2); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="copyright">
            <div class="row">
                <div class="col-md-12 align-self-center">
                    <p class="copyright-text text-center">
                        &copy; <span id="date"></span> <?php echo e($setup->copyright_text); ?> | Developed by <a
                            href="https://techuptechnologies.com/web-designing-company-in-varanasi/"> Techup
                            Technologies </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->


<!-- scroll-top -->
<a href="#" id="scroll-top"><i class="far fa-arrow-up"></i></a>
<!-- scroll-top end -->


<!-- js -->
<script data-cfasync="false" src="../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<script src="<?php echo e(asset('frontend/js/jquery-3.7.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/modernizr.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/imagesloaded.pkgd.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/isotope.pkgd.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.appear.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.easing.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/counter-up.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.nice-select.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/main.js')); ?>"></script>
<script>
    function validatePhone(input) {
        const value = input.value;
        const sanitizedValue = value.replace(/\D/g, '');

        input.value = sanitizedValue;

        if (sanitizedValue.length > 10) {
            input.value = sanitizedValue.slice(0, 10);
        }
    }
</script>
<?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/frontend/layouts/footer.blade.php ENDPATH**/ ?>