  <!--==============================
   Footer Area
 ==============================-->
  <?php
      $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
      $courses = App\Models\Course::orderBy('id', 'desc')->where('delete_status', '0')->take('12')->get();
  ?>
  <?php if(Route::currentRouteName() == 'contact-us'): ?>
      <footer class="footer-layout--style5 z-index-common background-image"
          style="background-image: url('<?php echo e(asset('frontend/img/bg/footer-bg-5-1.jpg')); ?>');">
  <?php else: ?>
    <footer class="footer-layout--style5 z-index-common"
        data-bg-src="<?php echo e(asset('frontend/img/bg/footer-bg-5-1.jpg')); ?>">
  <?php endif; ?>
  <div class="overlay"></div>
  <div class="container">
      <div class="footer-layout__top">
          <div class="row justify-content-center justify-content-lg-between">
              <div class="col-md-12 col-lg-3 col-xl-4">
                  <div class="widget footer-widget">
                      <h3 class="widget_title">About Company</h3>
                      <div class="vs-widget-about">
                          <?php if($setup && $setup->about_footer): ?>
                              <p class="footer-text"><?php echo $setup->about_footer; ?></p>
                          <?php endif; ?>
                          <span class="footer-since">Since 2000</span>
                          <div class="footer-schedule">
                              <span class="schedule-title">We Are Available</span>
                              <p class="schedule-timing">Mon - Sat: 10:00am to 07:30pm</p>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="col-md-12 col-lg-6 col-xl-5">
                  <div class="widget footer-widget">
                      <h3 class="widget_title">Our Services</h3>
                      <div class="footer-menu--style style2">
                          <ul>
                              <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <li><a
                                          href="<?php echo e(route('service-detail', $course->slug)); ?>"><?php echo e($course->course_name); ?></a>
                                  </li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </ul>
                      </div>
                  </div>
              </div>
              <div class="col-md-12 col-lg-3 col-xl-3">
                  <div class="widget footer-widget">
                      <h3 class="widget_title">information</h3>
                      <div class="footer-info--style2 v2">
                          <div class="footer-info_icon">
                              <i>
                                  <img src="<?php echo e(asset('frontend/img/icons/ct-icon-3.svg')); ?>" alt="location info">
                              </i>
                          </div>
                          <div class="media-body">
                              <span class="footer-info_label">Call Support 24/7</span>
                              <div class="footer-info_link call">
                                  <?php if($setup && $setup->contact_phone_1): ?>
                                      <a
                                          href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a>
                                  <?php endif; ?>
                                  <?php if($setup && $setup->contact_phone_2): ?>
                                      <a
                                          href="tel:+91-<?php echo e($setup->contact_phone_2); ?>">+91-<?php echo e($setup->contact_phone_2); ?></a>
                                  <?php endif; ?>
                                  <?php if($setup && $setup->contact_phone_3): ?>
                                      <a
                                          href="tel:+91-<?php echo e($setup->contact_phone_3); ?>">+91-<?php echo e($setup->contact_phone_3); ?></a>
                                  <?php endif; ?>
                              </div>
                          </div>
                      </div>
                      <?php if($setup && $setup->contact_email_1 || $setup->contact_email_2): ?>
                          <div class="footer-info--style2 v2 pt-3">
                              <div class="footer-info_icon">
                                  <i>
                                      <img src="<?php echo e(asset('frontend/img/icons/open-mail-info.svg')); ?>"
                                          alt="location info">
                                  </i>
                              </div>
                              <div class="media-body">
                                  <span class="footer-info_label">Email Address:</span>
                                  <div class="footer-info_link">
                                      <a href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a>
                                      <a href="mailto:<?php echo e($setup->contact_email_2); ?>"><?php echo e($setup->contact_email_2); ?></a>
                                  </div>
                              </div>
                          </div>
                      <?php endif; ?>
                      <?php if($setup && $setup->contact_address): ?>
                          <div class="footer-info--style2 v2 pt-3">
                              <div class="footer-info_icon">
                                  <i>
                                      <img src="<?php echo e(asset('frontend/img/icons/location-info.svg')); ?>"
                                          alt="location info">
                                  </i>
                              </div>
                              <div class="media-body">
                                  <span class="footer-info_label">Address:</span>
                                  <div class="footer-info_link">
                                      <?php echo e($setup->contact_address); ?>

                                  </div>
                              </div>
                          </div>
                      <?php endif; ?>
                  </div>
              </div>
          </div>
      </div>
      <div class="footer-layout__bottom2">
          <div class="row g-4 align-items-center justify-content-center justify-content-lg-between">
              <div class="col-xl-auto col-lg-6 col-md-8">
                  <p class="copyright-text4 text-center text-lg-start">©
                      <?php if($setup && $setup->copyright_text): ?>
                          <?php echo e($setup->copyright_text); ?>

                      <?php endif; ?> Developed By <a href="https://techuptechnologies.com/">Techup
                          Technologies</a>
                  </p>
              </div>
              <div class="col-xl-auto col-lg-auto col-md-6">
                  <div class="widget footer-widget2">
                      <div class="social-style">
                          <ul>
                              <?php if($setup && $setup->facebook_link): ?>
                                  <li>
                                      <a href="<?php echo e($setup->facebook_link); ?>"><i class="fab fa-facebook"></i></a>
                                  </li>
                              <?php endif; ?>
                              <?php if($setup && $setup->twitter_link): ?>
                                  <li>
                                      <a href="<?php echo e($setup->twitter_link); ?>"><i class="fab fa-twitter"></i></a>
                                  </li>
                              <?php endif; ?>
                              
                              <?php if($setup && $setup->instagram_link): ?>
                                  <li>
                                      <a href="<?php echo e($setup->instagram_link); ?>"><i class="fab fa-instagram"></i></a>
                                  </li>
                              <?php endif; ?>
                              <?php if($setup && $setup->youtube_link): ?>
                                  <li>
                                      <a href="<?php echo e($setup->youtube_link); ?>"><i class="fab fa-youtube"></i></a>
                                  </li>
                              <?php endif; ?>
                          </ul>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
  </footer>
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>
  <!--********************************
   Code End  Here
 ******************************** -->
<?php /**PATH C:\xampp\htdocs\econsultancy\resources\views/frontend/layouts/footer.blade.php ENDPATH**/ ?>