<!-- header area -->
<header class="header">

    <!-- header top -->
    <div class="header-top">
        <div class="container">
            <div class="header-top-wrap">
                <div class="header-top-left d-xl-block d-lg-block d-none">
                    <div class="header-top-list">
                        <ul>
                            <?php if(isset($setup->contact_email_1)): ?>
                                <li><a href="mailto:<?php echo e($setup->contact_email_1); ?>"><i
                                            class="far fa-envelopes"></i><?php echo e($setup->contact_email_1); ?></a></li>
                            <?php endif; ?>
                            <?php if(isset($setup->contact_phone_1)): ?>
                                <li>
                                    <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>"><i class="far fa-phone-volume"></i>
                                        +91-<?php echo e($setup->contact_phone_1); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="header-top-right">
                    <div class="header-top-social">
                        <?php if(isset($setup->facebook_link)): ?>
                            <a href="<?php echo e($setup->facebook_link); ?>"><i class="fab fa-facebook"></i></a>
                        <?php endif; ?>
                        <?php if(isset($setup->twitter_link)): ?>
                            <a href="<?php echo e($setup->twitter_link); ?>"><i class="fab fa-x-twitter"></i></a>
                        <?php endif; ?>
                        <?php if(isset($setup->instagram_link)): ?>
                            <a href="<?php echo e($setup->instagram_link); ?>"><i class="fab fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if(isset($setup->linkedin_link)): ?>
                            <a href="<?php echo e($setup->linkedin_link); ?>"><i class="fab fa-linkedin"></i></a>
                        <?php endif; ?>
                        <?php if(isset($setup->youtube_link)): ?>
                            <a href="<?php echo e($setup->youtube_link); ?>"><i class="fab fa-youtube"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header top end -->

    <!-- navbar -->
    <div class="main-navigation">
        <nav class="navbar navbar-expand-lg">
            <div class="container position-relative">
                <?php if(isset($setup->logo)): ?>
                    <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                        <img src="<?php echo e(asset('backend/images/website/' . $setup->logo)); ?>" alt="logo">
                    </a>
                <?php endif; ?>
                <div class="mobile-menu-right">
                    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar"
                        aria-label="Toggle navigation">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel">
                    <div class="offcanvas-header">
                        <?php if(isset($setup->logo)): ?>
                            <a href="<?php echo e(route('home')); ?>" class="offcanvas-brand" id="offcanvasNavbarLabel">
                                <img src="<?php echo e(asset('backend/images/website/' . $setup->logo)); ?>" alt="">
                            </a>
                        <?php endif; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"><i
                                class="far fa-xmark"></i></button>
                    </div>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">About</a>
                                <ul class="dropdown-menu fade-down">
                                    <li><a class="dropdown-item" href="<?php echo e(route('about')); ?>">About Us</a></li>
                                    <li><a class="dropdown-item" href="<?php echo e(route('director')); ?>">Director Desk</a></li>
                                    <li><a class="dropdown-item" href="<?php echo e(route('team')); ?>">Our Team</a></li>
                                </ul>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('service')); ?>">Services</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('why-solar')); ?>">Why Solar</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('product')); ?>">Products</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('faq')); ?>">Faq</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('contact')); ?>">Contact Us</a></li>
                        </ul>
                        <!-- nav-right -->
                        <div class="nav-right">
                            <button type="button" class="sidebar-btn nav-right-link" data-bs-toggle="offcanvas"
                                data-bs-target="#sidebarPopup">
                                <span></span>
                                <span></span>
                                <span></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <!-- navbar end-->

</header>
<!-- header area end -->


<!-- sidebar-popup -->
<div class="sidebar-popup offcanvas offcanvas-end" tabindex="-1" id="sidebarPopup">
    <div class="offcanvas-header">
        <?php if(isset($setup->logo)): ?>
            <a href="<?php echo e(route('home')); ?>" class="sidebar-popup-logo">
                <img src="<?php echo e(asset('backend/images/website/' . $setup->logo)); ?>" alt="">
            </a>
        <?php endif; ?>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
            <i class="far fa-xmark"></i>
        </button>
    </div>
    <div class="sidebar-popup-wrap offcanvas-body">
        <div class="sidebar-popup-content">
            <div class="sidebar-popup-about">
                <h4>About Us</h4>
                <p>We are dedicated to providing clean, reliable, and affordable solar energy solutions for homes and
                    businesses. With a strong commitment to sustainability, we help reduce energy costs while promoting
                    a greener future for our planet.</p>
            </div>
            <div class="sidebar-popup-contact">
                <h4>Contact Info</h4>
                <ul>
                    <?php if($setup->contact_email_1 || $setup->contact_email_2): ?>
                        <li>
                            <div class="icon">
                                <i class="far fa-envelope"></i>
                            </div>
                            <div class="content">
                                <h6>Email</h6>
                                <?php if(isset($setup->contact_email_1)): ?>
                                    <a href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a>
                                <?php endif; ?>
                                <?php if(isset($setup->contact_email_2)): ?>
                                    <br>
                                    <a href="mailto:<?php echo e($setup->contact_email_2); ?>"><?php echo e($setup->contact_email_2); ?></a>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if($setup->contact_phone_1 || $setup->contact_phone_2): ?>
                        <li>
                            <div class="icon">
                                <i class="far fa-phone"></i>
                            </div>
                            <div class="content">
                                <h6>Phone</h6>
                                <?php if(isset($setup->contact_phone_1)): ?>
                                    <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a>
                                <?php endif; ?>
                                <?php if(isset($setup->contact_phone_2)): ?>
                                    <br>
                                    <a href="tel:+91-<?php echo e($setup->contact_phone_2); ?>">+91-<?php echo e($setup->contact_phone_2); ?></a>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if(isset($setup->contact_address)): ?>
                        <li>
                            <div class="icon">
                                <i class="far fa-location-dot"></i>
                            </div>
                            <div class="content">
                                <h6>Address</h6>
                                <?php echo e($setup->contact_address); ?>

                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="sidebar-popup-social">
                <h4>Follow Us</h4>
                <?php if(isset($setup->facebook_link)): ?>
                    <a href="<?php echo e($setup->facebook_link); ?>"><i class="fab fa-facebook"></i></a>
                <?php endif; ?>
                <?php if(isset($setup->twitter_link)): ?>
                    <a href="<?php echo e($setup->twitter_link); ?>"><i class="fab fa-x-twitter"></i></a>
                <?php endif; ?>
                <?php if(isset($setup->instagram_link)): ?>
                    <a href="<?php echo e($setup->instagram_link); ?>"><i class="fab fa-instagram"></i></a>
                <?php endif; ?>
                <?php if(isset($setup->linkedin_link)): ?>
                    <a href="<?php echo e($setup->linkedin_link); ?>"><i class="fab fa-linkedin"></i></a>
                <?php endif; ?>
                <?php if(isset($setup->youtube_link)): ?>
                    <a href="<?php echo e($setup->youtube_link); ?>"><i class="fab fa-youtube"></i></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<!-- sidebar-popup end -->
<?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/frontend/layouts/header.blade.php ENDPATH**/ ?>