<?php $__env->startSection('content'); ?>
    <main class="main">

        <!-- breadcrumb -->
        <div class="site-breadcrumb" style="background: url('<?php echo e(asset('frontend/img/breadcrumb/01.jpg')); ?>')">
            <div class="container">
                <h2 class="breadcrumb-title">Our Products</h2>
                <ul class="breadcrumb-menu">
                    <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="active">Our Products</li>
                </ul>
            </div>
        </div>
        <!-- breadcrumb end -->


        <!-- shop-area -->
        <div class="shop-area bg py-50">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-4 element1">
                        <div class="shop-sidebar">
                            <div class="widget">
                                <div class="contact-form-header">
                                    <h2>Get a Call Back</h2>
                                </div>
                                <div class="form-message"></div>
                                <form method="post" action="<?php echo e(route('contactform')); ?>" id="contact-form">
                                    <?php echo csrf_field(); ?>
                                    <?php if($message = Session::get('success')): ?>
                                        <div class="alert alert-success" id="success-message">
                                            <p><?php echo e($message); ?></p>
                                        </div>
                                        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                                        <script>
                                            $(document).ready(function() {
                                                setTimeout(function() {
                                                    $('#success-message').fadeOut('slow');
                                                }, 3000);
                                            });
                                        </script>
                                    <?php endif; ?>
                                    <div class="form-group">
                                        <div class="form-icon">
                                            <i class="far fa-user-tie"></i>
                                            <input type="text" class="form-control" name="name"
                                                value="<?php echo e(old('name')); ?>" placeholder="Your Name" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-icon">
                                            <i class="far fa-envelope"></i>
                                            <input type="email" class="form-control" name="email"
                                                value="<?php echo e(old('email')); ?>" placeholder="Your Email" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-icon">
                                            <i class="far fa-phone"></i>
                                            <input type="text" class="form-control" name="number"
                                                value="<?php echo e(old('number')); ?>" placeholder="Your Phone"
                                                oninput="validatePhone(this)" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-icon">
                                            <i class="far fa-pen"></i>
                                            <input type="text" class="form-control" name="subject"
                                                value="<?php echo e(old('subject')); ?>" placeholder="Your Subject" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-icon">
                                            <i class="far fa-comment-lines"></i>
                                            <textarea name="message" cols="30" rows="3" class="form-control" placeholder="Write Your Message">
                                                <?php echo e(old('message')); ?>

                                            </textarea>
                                        </div>
                                    </div>
                                    <button type="submit" class="theme-btn">Send
                                        Message <i class="far fa-paper-plane"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8 element2">
                        <div class="shop-item-wrap">
                            <div class="row g-4 align-items-center">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-lg-4 col-6">
                                        <div class="shop-item mb-0">
                                            <div class="shop-item-img">
                                                <img src="<?php echo e(asset('backend/images/product/' . $data->image)); ?>"
                                                    onerror="this.onerror=null; this.src='frontend/img/Image-not-found.png'" alt="">
                                            </div>
                                            <div class="shop-item-info">
                                                <div class="shop-item-rate">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <h4 class="shop-item-title"><?php echo e($data->title); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="pagination-area mt-4">
                            <div aria-label="Page navigation example">
                                <ul class="pagination">
                                    
                                    <?php if($products->onFirstPage()): ?>
                                        <li class="page-item disabled">
                                            <a class="page-link" href="#" aria-label="Previous">
                                                <span aria-hidden="true"><i class="fas fa-arrow-left"></i></span>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e($products->previousPageUrl()); ?>"
                                                aria-label="Previous">
                                                <span aria-hidden="true"><i class="fas fa-arrow-left"></i></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    
                                    <?php $__currentLoopData = $products->links()->elements[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="page-item <?php echo e($products->currentPage() == $page ? 'active' : ''); ?>">
                                            <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    
                                    <?php if($products->hasMorePages()): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e($products->nextPageUrl()); ?>"
                                                aria-label="Next">
                                                <span aria-hidden="true"><i class="fas fa-arrow-right"></i></span>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <a class="page-link" href="#" aria-label="Next">
                                                <span aria-hidden="true"><i class="fas fa-arrow-right"></i></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- shop-area end -->

    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/frontend/product.blade.php ENDPATH**/ ?>