<?php

    $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();

?>

<!-- footer start -->
<footer class="footer widget-footer clearfix">
    <div class="second-footer prt-bgimage-yes prt-bg">
        <div class="prt-row-wrapper-bg-layer prt-bg-layer"></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widgte-text">
                            <img src="<?php echo e($setup ? asset('../backend/images/website/' . $setup->footer_logo) : ''); ?>"
                                width="250" alt="Logo">
                            <hr>
                            <span class="text-white">
                                <?php echo $setup ? $setup->about_footer : ''; ?>

                            </span>
                        </div>
                        <div class="widgte-text">
                            <div class="tollfree-img">
                                <img src="<?php echo e(asset('../frontend/images/logo/24-hr.png')); ?>" width="50"
                                    alt="Logo">
                                <span class="text-danger">Toll Free : </span><a href="tel:+91-<?php echo e($setup ? $setup->contact_phone_1 : ''); ?>"
                                    class="toll-no">+91-<?php echo e($setup ? $setup->contact_phone_1 : ''); ?></a>
                            </div>
                        </div>
                        <div class="widget_social">
                            <div class="social-icons social-hover">
                                <ul class="social-icons d-flex">
                                    <li>
                                        <a class="prt-social-instagram"
                                            href="<?php echo e($setup ? $setup->instagram_link : ''); ?>" target="_blank"><i
                                                class="icon-instagram"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-facebook" href="<?php echo e($setup ? $setup->facebook_link : ''); ?>"
                                            target="_blank"><i class="icon-facebook"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-twitter" href="<?php echo e($setup ? $setup->twitter_link : ''); ?>"
                                            target="_blank"><i class="icon-twitter"></i></a>
                                    </li>

                                    <li>
                                        <a class="prt-social-linkedin" href="<?php echo e($setup ? $setup->linkedin_link : ''); ?>"
                                            target="_blank"><i class="icon-linkedin"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-youtube" href="<?php echo e($setup ? $setup->youtube_link : ''); ?>"
                                            target="_blank"><i class="icon-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Quick Links</h3>
                            </div>
                            <ul class="menu-footer-quick-links">
                                <li><a href="<?php echo e(route('about')); ?>"><i class="fa fa-angle-right"></i>About Us</a></li>
                                <li><a href="<?php echo e(route('blog')); ?>"><i class="fa fa-angle-right"></i>Our Blogs </a></li>
                                <li><a href="#"><i class="fa fa-angle-right"></i>Careers </a></li>
                                <li><a href="<?php echo e(route('contact')); ?>"><i class="fa fa-angle-right"></i>Contact Us </a>
                                </li>
                                <li><a href="<?php echo e(route('privacy')); ?>"><i class="fa fa-angle-right"></i>Privacy Policy </a></li>
                                <li><a href="<?php echo e(route('terms')); ?>"><i class="fa fa-angle-right"></i>Terms & Conditions </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Bank Details</h3>
                            </div>
                            <ul class="menu-footer-quick-links">
                                <p><?php echo $setup->bank_detail; ?></p>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget-title">
                        <h3>Get In Touch</h3>
                    </div>
                    <div class="res-767-pb-18">
                        <p><i class="fa fa-map-marker "></i>&nbsp; <?php echo $setup ? $setup->contact_address : ''; ?></p>
                        <p><i class="fa fa-map-marker "></i>&nbsp; <?php echo $setup ? $setup->contact_address_2 : ''; ?></p>
                        <p><i class="fa fa-phone"></i>&nbsp;
                            <a href="tel:+91-<?php echo e($setup ? $setup->contact_phone_3 : ''); ?>">+91-<?php echo e($setup ? $setup->contact_phone_3 : ''); ?></a>,
                            <a href="tel:+91-<?php echo $setup ? $setup->contact_phone_4 : ''; ?>"><?php echo $setup ? $setup->contact_phone_4 : ''; ?></a>
                        </p>
                        <p><i class="fa fa-envelope"></i>&nbsp;
                            <a href="mailto:<?php echo e($setup ? $setup->contact_email_1 : ''); ?>"><?php echo e($setup ? $setup->contact_email_1 : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bottom-footer-text prt-bg copyright">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="text-left">
                        <span class="cpy-text"> ©
                            <?php echo $setup ? $setup->copyright_text : ''; ?> All Rights Reserved. Developed By <a
                                href="https://techuptechnologies.com/" target="_blank">Techup Technologies</a></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer><!-- footer end -->

<!-- Start OnClick Modal -->
<div class="modal" id="myModal" data-bs-keyboard="false" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Consultation Now</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa fa-times"
                        aria-hidden="true"></i></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <form action="<?php echo e(route('contactform')); ?>" class="contact_form clearfix" method="post">
                        <?php echo csrf_field(); ?>
                        <?php if($message = Session::get('success')): ?>
                            <div class="alert alert-success">
                                <p><?php echo e($message); ?></p>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <form action="<?php echo e(route('contactform')); ?>" class="contact_form clearfix" method="post">
                                <?php echo csrf_field(); ?>
                                <?php if($message = Session::get('success')): ?>
                                    <div class="alert alert-success">
                                        <p><?php echo e($message); ?></p>
                                    </div>
                                <?php endif; ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" name="name" class="form-control"
                                            value="<?php echo e(old('name')); ?>" placeholder="Your Name *" required="">
                                        <?php if($errors->has('name')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="email" name="email" class="form-control"
                                            value="<?php echo e(old('email')); ?>" placeholder="Your Email *" required="">
                                        <?php if($errors->has('email')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('email')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="number" name="number" class="form-control"
                                            value="<?php echo e(old('number')); ?>" maxlength="10" pattern="[0-9]{10}"
                                            placeholder="Your Number *" required="">
                                        <?php if($errors->has('number')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('number')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="services" class="form-control"
                                            value="<?php echo e(old('services')); ?>" placeholder="Service You Need *"
                                            required="">
                                        <?php if($errors->has('services')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('services')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="city" class="form-control"
                                            value="<?php echo e(old('city')); ?>" placeholder="Your City *" required="">
                                        <?php if($errors->has('city')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('city')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="state" class="form-control"
                                            value="<?php echo e(old('state')); ?>" placeholder="Your State *" required="">
                                        <?php if($errors->has('state')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('state')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-12">
                                        <textarea name="message" class="form-control textarea" placeholder="Type Your Message Here . . ."><?php echo e(old('message')); ?></textarea>
                                    </div>
                                    <div class="mt-5 text-center">
                                        <button
                                            class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor"
                                            type="submit" value="submit">Submit Here <i
                                                class="fa fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- End OnClick Modal -->


<!-- back-to-top start -->
<a id="totop" href="#top">
    <i class="fa fa-angle-up"></i>
</a>
<!-- back-to-top end -->
<?php if($setup && $setup->contact_phone_1): ?>
    <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>" class="float1" target="_blank"> <i
            class="flaticon-phone-call my-float"></i> </a>
<?php endif; ?>
<?php if($setup && $setup->whatsapp_link): ?>
    <a href="https://api.whatsapp.com/send?phone=<?php echo e($setup->whatsapp_link); ?>&amp;text=" class="float"
        target="_blank">
        <i class="fa fa-whatsapp my-float"></i></a>
<?php endif; ?>

</div><!-- page end -->
<!-- Javascript -->
<script src="<?php echo e(asset('frontend/js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-migrate-3.3.2.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/bootstrap.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/aos.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-validate.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.prettyPhoto.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-waypoints.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/numinate.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/imagesloaded.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-isotope.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.twentytwenty.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/circle-progress.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/main.js')); ?>"></script>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\tpl-groups\resources\views/frontend/layouts/footer.blade.php ENDPATH**/ ?>