<?php $__env->startSection('content'); ?>
    <?php
        $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
    ?>
    <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('frontend/img/breadcumb/breadcumb-bg.jpg')); ?>">
        <div class="container z-index-common">
            <div class="breadcumb-content">
                <h5 class="breadcumb-title">Services</h5>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li>Services</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!--==============================
                Service Area
                ==============================-->
    <section class="service--layout1 space-top space-extra-bottom">
        <div class="container">
            <div class="title-area text-center">
                <span class="sec-icon">
                    <img src="<?php echo e(asset('frontend/img/favicon.png')); ?>" alt="icon">
                </span>
                <span class="sec-subtitle2">Quality Servicing Opportunity</span>
                <h2 class="sec-title">Quality Services</h2>
            </div>
            <div class="row">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4">
                        <div class="service-block" data-bg-src="<?php echo e(asset('frontend/img/textures/service-block-bg.png')); ?>">
                            <div class="service-block__icon">
                                <img src="<?php echo e(asset('backend/images/coursecat/' . $category->course_img)); ?>" alt="icon"
                                    onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.svg')); ?>'">
                            </div>
                            <h3 class="service-block__title h4">
                                <a class="service-block__title__link"
                                    href="<?php echo e(route('service.list', $category->slug)); ?>"><?php echo e($category->course_name); ?></a>
                            </h3>
                            <p class="service-block__text"><?php echo $category->course_description; ?></p>
                            <a href="<?php echo e(route('service.list', $category->slug)); ?>" class="service-block__link">
                                <i class="far fa-arrow-right"></i>
                            </a>
                            <div class="service-block__shape">
                                <svg width="372.006" height="87" viewBox="0 0 372.006 87">
                                    <g transform="translate(-374.997 -2256)">
                                        <path d="M448.062,2278.9l50.349,19.889-98.825,28.254-18.356,4.685Z"
                                            fill="#f0f0f0" />
                                        <path d="M665.6,2256l81.4,86.332L432.178,2343,375,2341.7Z" fill="#f0f0f0" />
                                    </g>
                                </svg>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <!-- Pagination Links -->
                <div class="pagination-wrapper text-center">
                    <?php echo e($categories->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\econsultancy\resources\views/frontend/services.blade.php ENDPATH**/ ?>