<?php
    $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
?>
<div class="wrapper">
    <div class="leftside-menu">

        <!-- LOGO -->
        <a href="/admin/dashboard" class="logo text-center logo-light"
            style="background: #fff !important; border-bottom: 2px solid #fff">
            <?php if($setup && $setup->logo): ?>
                <span class="logo-lg" style="background: #313a46;">
                    <img src="<?php echo e(asset('backend/images/website/' . $setup->logo)); ?>"
                        onerror="this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'; this.onerror='';" alt=""
                        style="width: 160px; height: 50px;">
                </span>
            <?php endif; ?>
            <span class="logo-sm">
                <img src="<?php echo e(asset('frontend/img/favicon.png')); ?>" alt="" height="30">
            </span>
        </a>

        <div class="h-100 pt-2" id="leftside-menu-container" data-simplebar>

            <!--- Sidemenu -->
            <ul class="side-nav">

                <li class="side-nav-item">
                    <a href="/admin/dashboard"
                        class="side-nav-link <?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>">
                        <i class="uil-home-alt"></i>
                        <span> Dashboards </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('site.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('site.index') ? 'active' : ''); ?>">
                        <i class="uil-sitemap"></i>
                        <span> Sites </span>
                    </a>
                </li>

                


                

                

                <li class="side-nav-item">
                    <a href="<?php echo e(route('slider.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('slider.index') ? 'active' : ''); ?>">
                        <i class="uil uil-image"></i>
                        <span> Sliders </span>
                    </a>
                </li>

                

                

                <li class="side-nav-item">
                    <a href="<?php echo e(route('blog.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('blog.index') ? 'active' : ''); ?>">
                        <i class="dripicons-blog"></i>
                        <span> Blogs </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('client.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('client.index') ? 'active' : ''); ?>">
                        <i class="uil-chat-bubble-user"></i>
                        <span> Client </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('career.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('career.index') ? 'active' : ''); ?>">
                        <i class="uil-briefcase-alt"></i>
                        <span> Career </span>
                    </a>
                </li>
                <li class="side-nav-item">
                    <a href="<?php echo e(route('team.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('team.index') ? 'active' : ''); ?>">
                        <i class="uil-users-alt"></i>
                        <span> Team </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('testimonial.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('testimonial.index') ? 'active' : ''); ?>">
                        <i class="uil-comment"></i>
                        <span> Testimonials </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('enquiry.index')); ?>"
                        class="side-nav-link <?php echo e(request()->routeIs('enquiry.index') ? 'active' : ''); ?>">
                        <i class="uil-comment-question"></i>
                        <span> Enquiry </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('website.index')); ?>" class="side-nav-link class="side-nav-link
                        <?php echo e(request()->routeIs('website.index') ? 'active' : ''); ?>">
                        <i class="uil-cog"></i>
                        <span> Website Setup </span>
                    </a>
                </li>

            </ul>
            <!-- End Sidebar -->

            <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
<?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/backend/layouts/sidebar.blade.php ENDPATH**/ ?>