<?php $__env->startSection('content'); ?>
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="<?php echo e(route('team.index')); ?>" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-reply me-1"></i> All Team
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Team</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Image</th>
                                            <th>Name</th>
                                            <th>Designation</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="table-user">
                                                    <img id="blah"
                                                        src="<?php echo e(URL::asset('backend/images/team/' . $data->image)); ?>"
                                                        alt="your image"
                                                        onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.svg')); ?>'" />
                                                </td>
                                                <td><?php echo e($data->name); ?></td>
                                                <td><?php echo e($data->designation); ?></td>

                                                <td class="table-action d-flex">

                                                    <a href="<?php echo e(route('team.edit', $data->id)); ?>" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="<?php echo e(route('team.destroy', $data->id)); ?>" method="POST">
                                                        <?php echo method_field('DELETE'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                <?php if(isset($team) && isset($team->id)): ?>
                                    <form action="<?php echo e(route('team.update', $team->id)); ?>" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        <?php echo method_field('PUT'); ?>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('team.store')); ?>" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                <?php endif; ?>

                                <?php echo csrf_field(); ?>


                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Name</label>
                                        <input type="text" class="form-control" name="name"
                                            <?php if(isset($team)): ?> value="<?php echo e(old('name', optional($team)->name)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Designation</label>
                                        <input type="text" class="form-control" name="designation"
                                            <?php if(isset($team)): ?> value="<?php echo e(old('designation', optional($team)->designation)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="image" class="form-control">
                                        <?php if(isset($team)): ?>
                                            <img id="img" src="<?php echo e(URL::asset('backend/images/team/' . old('image', optional($team)->image))); ?>"
                                                onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'"
                                                style="width: 35%;" />
                                        <?php else: ?>
                                            <img class="mt-2" id="img" src="<?php echo e(asset('backend/images/no_image.png')); ?>" onerror="this.onerror=null;this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'" height="100px" width="100px">
                                        <?php endif; ?>
                                    </div>



                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\econsultancy\resources\views/backend/team/index.blade.php ENDPATH**/ ?>