<?php $__env->startSection('content'); ?>
    <div class="search-overlay">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-close">
                    <span class="search-close-line"></span>
                    <span class="search-close-line"></span>
                </div>
                <div class="search-form">
                    <form>
                        <input type="text" class="input-search" placeholder="Search here...">
                        <button type="submit"><i class="bx bx-search"></i></button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="banner-slider-area">
        <div class="banner-slider owl-carousel owl-theme">
            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="banner-item"
                    style="background-image: url('<?php echo e(asset('backend/images/slider/' . $slider->image)); ?>');">
                    <div class="d-table">
                        <div class="d-table-cell">
                            <div class="container">
                                <div class="banner-item-content">
                                    <span><?php echo e(env('APP_NAME')); ?></span>
                                    <h1><?php echo e($slider->title); ?></h1>
                                    <p>
                                        Analysis Research Management Services has completed more than 350 clinical trial
                                        studies of various
                                        sponsors and CRO’s at various sites in Varanasi.
                                    </p>
                                    <div class="banner-btn">
                                        <a href="<?php echo e(route('about')); ?>" class="default-btn btn-bg-two border-radius-50">Learn
                                            More <i class="bx bx-chevron-right"></i></a>
                                        <a href="<?php echo e(route('contact-us')); ?>" class="default-btn btn-bg-one border-radius-50 ml-20">Get A
                                            Quote <i class="bx bx-chevron-right"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>


    <div class="about-area ptb-100">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-6">
                    <div class="about-content mr-20">
                        <div class="section-title">
                            <span class="sp-color2">Welcome To <?php echo e(env('APP_NAME')); ?></span>
                            <h2>Pioneering the Future of Clinic Management</h2>
                            <p>
                                Analysis Research Management Services (ARMS) is a premier site management firm based
                                in Varanasi, dedicated to excellence in clinical trial management. Our expertise spans
                                across
                                multiple aspects of site management, ensuring efficient and effective execution of clinical
                                trials.
                            </p>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-6">
                                <div class="about-content-card">
                                    <i class="flaticon-practice"></i>
                                    <h3>Experience</h3>
                                    <p>Successfully completed over 350 clinical trial studies, partnering with top
                                        sponsors and CROs</p>
                                </div>
                            </div>
                            <div class="col-lg-6 col-6">
                                <div class="about-content-card">
                                    <i class="flaticon-help"></i>
                                    <h3>Quick Support</h3>
                                    <p> Our team is dedicated to continuously improving our services based on your feedback.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="about-img">
                        <img src="<?php echo e(asset('frontend/images/about/about-img1.jpg')); ?>" alt="About Images">
                        <div class="sub-content">
                            <img src="<?php echo e(asset('frontend/images/about/about-img2.jpg')); ?>" alt="About Images">
                            <div class="content">
                                <h3>350<sup>+</sup></h3>
                                <span>Satisfied Clients</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <section class="services-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color1">Our Key Highlights</span>
                <h2>We Provide a Wide Variety of Clinical Trial Management</h2>
                <p class="margin-auto">
                    <?php echo e(env('APP_NAME')); ?> specialized and committed to delivering some of the most complex clinical projects
                    in the industry.
                </p>
            </div>
            <div class="row pt-45">
                <div class="col-lg-4 col-sm-6">
                    <div class="services-card">
                        <i class="flaticon-consultant"></i>
                        <h3><a href="#">Comprehensive Clinical Trial Management</a></h3>
                        <div class="side-bar-widget">
                            <div class="side-bar-categories">
                                <ul>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Successfully completed over 350 clinical trial studies, partnering with top
                                            sponsors and CROs.
                                        </span>
                                    </li>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Currently overseeing 26 active clinical studies across various therapeutic
                                            areas.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="services-card">
                        <i class="flaticon-consulting"></i>
                        <h3><a href="service-details.html">Strategic Site Operations</a></h3>
                        <div class="side-bar-widget">
                            <div class="side-bar-categories">
                                <ul>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Managing operations at 10 strategically located sites within Varanasi,
                                            optimizing accessibility and resource allocation.
                                        </span>
                                    </li>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Equipped with state-of-the-art facilities to support complex clinical trials.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="services-card">
                        <i class="flaticon-web-development"></i>
                        <h3><a href="service-details.html">Expert Workforce</a></h3>
                        <div class="side-bar-widget">
                            <div class="side-bar-categories">
                                <ul>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            A dedicated team of 26 highly trained Clinical Research Coordinators.
                                        </span>
                                    </li>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Supported by a robust backend staff, ensuring seamless trial execution and
                                            data integrity.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="services-card">
                        <i class="flaticon-stats"></i>
                        <h3><a href="service-details.html">Quality & Compliance</a></h3>
                        <div class="side-bar-widget">
                            <div class="side-bar-categories">
                                <ul>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Adherence to the highest standards of Good Clinical Practice (GCP) and
                                            regulatory compliance.
                                        </span>
                                    </li>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Commitment to patient safety, data accuracy, and ethical conduct in all trials.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="services-card">
                        <i class="flaticon-effective"></i>
                        <h3><a href="#">Innovative Solutions</a></h3>
                        <div class="side-bar-widget">
                            <div class="side-bar-categories">
                                <ul>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Leveraging advanced technology and innovative methodologies to enhance
                                            trial efficiency and accuracy.
                                        </span>
                                    </li>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Continuous improvement through feedback and adaptive strategies.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="services-card">
                        <i class="flaticon-implement"></i>
                        <h3><a href="#">Community & Patient Focus</a></h3>
                        <div class="side-bar-widget">
                            <div class="side-bar-categories">
                                <ul>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Active engagement with the local community to foster trust and participation.
                                        </span>
                                    </li>
                                    <li>
                                        <div class="line-circle"></div>
                                        <span class="learn-btn">
                                            Patient-centric approach ensuring comfort, safety, and transparency
                                            throughout the trial process.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <div class="service-shape">
            <img src="<?php echo e(asset('frontend/images/shape/service-shape1.png')); ?>" alt="Images">
        </div>
    </section>

    <div class="case-study-area pt-100 pb-70">
        <div class="container-fluid p-0">
            <div class="section-title text-center">
                <span class="sp-color2">Our Sites</span>
                <h2>Introduce Our Projects & Check Recent Sites </h2>
            </div>
            <div class="case-study-slider owl-carousel owl-theme pt-45">
                <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="case-study-item aspect-site">
                        <img src="<?php echo e(asset('backend/images/site/' . $site->image)); ?>"
                            onerror="this.onerror=null; this.src='<?php echo e(asset('frontend/images/no_image.jpg')); ?>'"
                            alt="Images">
                        <div class="content">
                            <h3><a href="<?php echo e(route('showsite', $site->slug)); ?>"><?php echo e($site->name); ?></a></h3>
                            <a href="<?php echo e(route('showsite', $site->slug)); ?>" class="more-btn"><i class="bx bx-right-arrow-alt"></i></a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>


    


    <div class="call-us-area">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="call-contact">
                        <h3>Call Us 24/7</h3>
                        <?php if(isset($setup->contact_phone_1)): ?>
                            <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>"
                                class="call-btn">+91-<?php echo e($setup->contact_phone_1); ?></a>
                        <?php endif; ?>
                        <p>Whether you’re a sponsor, investigator, or site, our team of experts is ready to support you
                            every step of the way. Reach out to us, and let’s work together to make your clinical trials
                            successful.</p>
                        <a href="<?php echo e(route('contact-us')); ?>" class="default-btn btn-bg-two border-radius-5">Contact Us</a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="call-us-img">
                        <div class="public-shape">
                            <img src="<?php echo e(asset('frontend/images/call-us/call-us-img1.png')); ?>" alt="Images">
                        </div>
                        <div class="call-shape">
                            <div class="shape1">
                                <img src="<?php echo e(asset('frontend/images/call-us/call-shap2.png')); ?>" alt="Images">
                            </div>
                            <div class="shape2 shape2-rs">
                                <img src="<?php echo e(asset('frontend/images/call-us/call-shap3.png')); ?>" alt="Images">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <section class="work-process-area services-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color2">Our Working Process</span>
                <h2>Brief Profile of <?php echo e(env('APP_NAME')); ?></h2>
                <p class="margin-auto">
                    <?php echo e(env('APP_NAME')); ?> is site management firm based in Varanasi and works in
                    following fields
            </div>
            <div class="row gutters-10 row-cols-xl-5 row-cols-md-5 row-cols-1 pt-45">
                <div class="col">
                    <div class="work-process-card">
                        <h3>Organization</h3>
                        <p>The organization is engaged in managing site activities pertaining to clinical trials.
                        </p>
                        <div class="number">01</div>
                    </div>
                </div>
                <div class="col">
                    <div class="work-process-card">
                        <h3>Sponsors & CRO’s</h3>
                        <p>ARMS has completed more than 350 clinical trial studies of various
                            sponsors and CRO’s at various sites in Varanasi.
                        </p>
                        <div class="number">02</div>
                    </div>
                </div>
                <div class="col">
                    <div class="work-process-card">
                        <h3>Execute</h3>
                        <p>The organization works with trained manpower which includes 16 Clinical Research Coordinators and
                            other backend staff.
                        </p>
                        <div class="number">03</div>
                    </div>
                </div>
                <div class="col">
                    <div class="work-process-card">
                        <h3>Clinical Studies</h3>
                        <p>At present 26 Clinical studies are going on at various sites.
                        </p>
                        <div class="number">04</div>
                    </div>
                </div>
                <div class="col">
                    <div class="work-process-card">
                        <h3>Sites</h3>
                        <p>Currently we are managing 10 sites in the city of Varanasi
                        </p>
                        <div class="number">05</div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <div class="counter-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color2">Numbers Are Talking</span>
                <h2>Let’s Check Our Business Growth and Success Story</h2>
                <p>Don’t put up with poor performance. For 25 years ARMS has built such trusted relationships with biotech
                    sponsors, that 90% of our customers are repeat and referral.
                </p>
            </div>
            <div class="row pt-45">
                <div class="col-lg-3 col-6 col-md-3">
                    <div class="counter-another-content">
                        <i class="flaticon-web-development"></i>
                        <h3 id="counter1">350<sup>+</sup></h3>
                        <span>Clinical Trials</span>
                    </div>
                </div>
                <div class="col-lg-3 col-6 col-md-3">
                    <div class="counter-another-content">
                        <i class="flaticon-consulting-1"></i>
                        <h3 id="counter2">26<sup>+</sup></h3>
                        <span>Clinical Studies</span>
                    </div>
                </div>
                <div class="col-lg-3 col-6 col-md-3">
                    <div class="counter-another-content">
                        <i class="flaticon-project"></i>
                        <h3 id="counter3">10<sup>+</sup></h3>
                        <span>Varanasi Sites</span>
                    </div>
                </div>
                <div class="col-lg-3 col-6 col-md-3">
                    <div class="counter-another-content">
                        <i class="flaticon-data-analytics"></i>
                        <h3 id="counter4">16<sup>+</sup></h3>
                        <span>CRO & Backend Staff</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="counter-shape">
            <div class="shape1">
                <img src="<?php echo e(asset('frontend/images/shape/shape1.png')); ?>" alt="Images">
            </div>
            <div class="shape2">
                <img src="<?php echo e(asset('frontend/images/shape/shape2.png')); ?>" alt="Images">
            </div>
        </div>
    </div>

    


    <section class="clients-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color2">Our Clients</span>
                <h2>Our Clients Feedback</h2>
            </div>
            <div class="clients-slider owl-carousel owl-theme pt-45">
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="clients-content">
                        <div class="content">
                            <img src="<?php echo e(asset('backend/images/testimonial/' . $testimonial->image)); ?>"
                                onerror="this.onerror=null;this.src='<?php echo e(asset('frontend/images/user_dp.webp')); ?>'"
                                alt="Images">
                            <i class="bx bxs-quote-alt-left"></i>
                            <h3><?php echo e($testimonial->title); ?></h3>
                            <span><?php echo e($testimonial->designation); ?></span>
                        </div>
                        <p>
                            <?php echo $testimonial->description; ?>

                        </p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="client-circle">
            <div class="client-circle-1">
                <div class="circle"></div>
            </div>
            <div class="client-circle-2">
                <div class="circle"></div>
            </div>
            <div class="client-circle-3">
                <div class="circle"></div>
            </div>
            <div class="client-circle-4">
                <div class="circle"></div>
            </div>
            <div class="client-circle-5">
                <div class="circle"></div>
            </div>
            <div class="client-circle-6">
                <div class="circle"></div>
            </div>
            <div class="client-circle-7">
                <div class="circle"></div>
            </div>
        </div>
    </section>


    <div class="blog-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color2">Latest Blog</span>
                <h2>Let’s Check Some Latest Blog</h2>
            </div>
            <div class="row pt-45">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="blog-card">
                            <div class="blog-img">
                                <a href="<?php echo e(route('blogs',$blog->slug )); ?>">
                                    <img src="<?php echo e(asset('backend/images/blog/' . $blog->image)); ?>" alt="Blog Images">
                                </a>
                                <div class="blog-tag">
                                    <h3><?php echo e($blog->created_at->format('d')); ?></h3>
                                    <span><?php echo e($blog->created_at->format('M')); ?></span>
                                </div>
                            </div>
                            <div class="content">
                                <ul>
                                    <li>
                                        <a href="#"><i class="bx bxs-user"></i> By ARMS</a>
                                    </li>
                                    <li>
                                        <a href="#"><i class="bx bx-purchase-tag-alt"></i>Business</a>
                                    </li>
                                </ul>
                                <a href="<?php echo e(route('blogs',$blog->slug )); ?>">
                                    <h3>
                                        <?php echo e($blog->title); ?>

                                    </h3>
                                </a>
                                <p><?php echo e($blog->short_description); ?></p>
                                <a href="<?php echo e(route('blogs',$blog->slug )); ?>" class="read-btn">Read More <i
                                        class="bx bx-chevron-right"></i></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="brand-area pb-70">
        <div class="container">
            <div class="brand-slider owl-carousel owl-theme">
                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="brand-item">
                        <img src="<?php echo e(asset('backend/images/client/' . $client->image)); ?>" class="brand-logo-one"
                            alt="Images">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/frontend/index.blade.php ENDPATH**/ ?>