<?php $__env->startSection('content'); ?>
    <div class="search-overlay">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-close">
                    <span class="search-close-line"></span>
                    <span class="search-close-line"></span>
                </div>
                <div class="search-form">
                    <form>
                        <input type="text" class="input-search" placeholder="Search here...">
                        <button type="submit"><i class="bx bx-search"></i></button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="inner-banner" id="banner-opc">
        <div class="container">
            <div class="inner-title text-center">
                <h3>Contact Us</h3>
                <ul>
                    <li>
                        <a href="index.html">Home</a>
                    </li>
                    <li>
                        <i class="bx bx-chevrons-right"></i>
                    </li>
                    <li>Contact Us</li>
                </ul>
            </div>
        </div>
        <div class="inner-shape">
            <img src="<?php echo e(asset('frontend/images/shape/inner-shape.png')); ?>" alt="Images">
        </div>
    </div>


    <div class="contact-form-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <h2>Let's Send Us a Message Below</h2>
            </div>
            <div class="row pt-45">
                <div class="col-lg-4">
                    <div class="contact-info mr-20">
                        <span>Contact Info</span>
                        <h2>Let's Connect With Us</h2>
                        <p>We are here to assist with any inquiries you may have regarding our clinical trial management
                            services. </p>
                        <ul>
                            <?php if(isset($setup->contact_phone_1) || isset($setup->contact_phone_2)): ?>
                                <li>
                                    <div class="content">
                                        <i class="bx bx-phone-call"></i>
                                        <h3>Phone Number</h3>
                                        <?php if(isset($setup->contact_phone_1)): ?>
                                            <a
                                                href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a>
                                        <?php endif; ?>
                                        <?php if(isset($setup->contact_phone_2)): ?>
                                            <a
                                                href="tel:+91-<?php echo e($setup->contact_phone_2); ?>">+91-<?php echo e($setup->contact_phone_2); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if(isset($setup->contact_address)): ?>
                                <li>
                                    <div class="content">
                                        <i class="bx bxs-map"></i>
                                        <h3>Address</h3>
                                        <span><?php echo e($setup->contact_phone_1); ?></span>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if(isset($setup->contact_email_1) || isset($setup->contact_email_2)): ?>
                                <li>
                                    <div class="content">
                                        <i class="bx bx-message"></i>
                                        <h3>Contact Info</h3>
                                        <?php if(isset($setup->contact_email_1)): ?>
                                            <a href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a>
                                            </h6>
                                        <?php endif; ?>
                                        <?php if(isset($setup->contact_email_2)): ?>
                                            <a href="mailto:<?php echo e($setup->contact_email_2); ?>"><?php echo e($setup->contact_email_2); ?></a>
                                            </h6>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="contact-form">
                        <form action="<?php echo e(route('contactform')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <?php if($message = Session::get('success')): ?>
                                <div class="alert alert-success" id="success-message">
                                    <p><?php echo e($message); ?></p>
                                </div>
                                <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                                <script>
                                    $(document).ready(function() {
                                        setTimeout(function() {
                                            $('#success-message').fadeOut('slow');
                                        }, 3000);
                                    });
                                </script>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Your Name <span>*</span></label>
                                        <input type="text" name="name" id="name" class="form-control" required
                                            value="<?php echo e(old('name')); ?>" data-error="Please Enter Your Name"
                                            placeholder="Name">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Your Email <span>*</span></label>
                                        <input type="email" name="email" id="email" class="form-control" required
                                            value="<?php echo e(old('email')); ?>" data-error="Please Enter Your Email"
                                            placeholder="Email">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Phone Number <span>*</span></label>
                                        <input type="text" name="number" id="phone_number" required
                                            value="<?php echo e(old('number')); ?>" data-error="Please Enter Your Number"
                                            class="form-control" placeholder="Phone Number" oninput="validatePhone(this)">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Your Subject <span>*</span></label>
                                        <input type="text" name="subject" id="msg_subject" class="form-control"
                                            value="<?php echo e(old('subject')); ?>" required data-error="Please Enter Your Subject"
                                            placeholder="Your Subject">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <label>Your Message <span>*</span></label>
                                        <textarea name="message" class="form-control" id="message" cols="30" rows="8" required
                                            data-error="Write Your Message" placeholder="Your Message"><?php echo e(old('message')); ?></textarea>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-12 col-md-12 text-center">
                                    <button type="submit" class="default-btn btn-bg-two border-radius-50">
                                        Send Message <i class="bx bx-chevron-right"></i>
                                    </button>
                                    <div id="msgSubmit" class="h3 text-center hidden"></div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="map-area">
        <div class="container-fluid m-0 p-0">
            <iframe class="gmap_iframe" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"
                src="https://maps.google.com/maps?width=1263&amp;height=400&amp;hl=en&amp;q=varanasi&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/frontend/contact.blade.php ENDPATH**/ ?>