<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\CareerController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\RegistrationController;
use App\Http\Controllers\CourseEnqueryController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('view_blog', function() {
//   return view('frontend.view-blog');
// });


// Route::view('/', 'frontend.index')->name('index');

Route::get('/', [FrontController::class,'homepage'])->name('home');

Route::get('about', [FrontController::class,'about'])->name('about');

Route::get('director', [FrontController::class,'director'])->name('director');

Route::get('directors-message', [FrontController::class,'director'])->name('team');

Route::get('why-solar', [FrontController::class,'whySolar'])->name('why-solar');

// Route::get('service', [FrontController::class,'service'])->name('service');

Route::get('business/{slug}', [FrontController::class,'serviceDetail'])->name('service-detail');

Route::get('product', [FrontController::class,'product'])->name('product');

Route::get('faq', [FrontController::class,'faq'])->name('faq');

Route::get('student-login', [FrontController::class,'student_login'])->name('student-login');

Route::get('download', [FrontController::class,'download'])->name('download');

Route::get('college', [FrontController::class,'college'])->name('college');

Route::get('courses', [FrontController::class,'courses'])->name('courses');

Route::get('gallery', [FrontController::class,'gallery'])->name('gallery');

Route::get('courses/{course_category_slug}', [FrontController::class,'showcourses'])->name('course');

Route::get('viewcourses/{slug}', [FrontController::class,'viewcourses'])->name('viewcourses');

// Route::get('testimonial', [FrontController::class,'testimonial'])->name('testimonial');

Route::get('career', [FrontController::class,'career'])->name('career');

Route::get('sites', [FrontController::class,'site'])->name('sites');

Route::get('site/{slug}', [FrontController::class,'showsite'])->name('showsite');

Route::get('company-policy', [FrontController::class,'companypolicy'])->name('companypolicy');

Route::get('blog', [FrontController::class,'blog'])->name('blog');

Route::get('blog/{slug}', [FrontController::class,'showblog'])->name('blogs');

Route::get('newsroom', [FrontController::class,'newsroom'])->name('newsroom');

Route::get('newsroom/{slug}', [FrontController::class,'shownewsroom'])->name('newsrooms');

Route::get('contact-us', [FrontController::class,'contactus'])->name('contact');

Route::get('appointment', [FrontController::class,'bookappointment'])->name('appointment');

Route::resource('course_enquiry', CourseEnqueryController::class);

Route::post('career', [CareerController::class,'store'])->name('careerform');

Route::post('contactform', [EnquiryController::class,'store'])->name('contactform');

Route::get('privacy-policy', [Frontcontroller::class,'privacy'])->name('privacy');

Route::get('terms-conditions', [Frontcontroller::class,'terms'])->name('terms');

// Route::view('gallery', 'frontend.gallery')->name('gallery');

// Route::view('course_details', 'frontend.course_details')->name('course_details');

Route::view('registration_form', 'frontend.registration_form')->name('registration_form');

Route::post('registration_form_store', [App\Http\Controllers\CourseController::class,'registration_form_store'])->name('registration_form_store');

Route::get('registration/{slug}',[RegistrationController::class,'index'])->name('registration');
Route::post('registration-store',[RegistrationController::class,'store'])->name('registration.store');
Route::get('registration-view',[RegistrationController::class,'show'])->name('registration-view');

// Auth::routes();

