@extends('frontend.layouts.app')
@section('content')
    <!-- page-title -->
    <div class="prt-titlebar-wrapper prt-bg about-img">
        <div class="prt-titlebar-wrapper-bg-layer prt-bg-layer"></div>
        <div class="prt-titlebar-wrapper-inner">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12">
                        <div class="prt-page-title-row-heading">
                            <div class="page-title-heading">
                                <h2 class="title">News Room's Details</h2>
                            </div>
                            <div class="breadcrumb-wrapper">
                                <i class="flaticon-home"></i>
                                <span>
                                    <a title="Homepage" href="/">Home</a>
                                </span>
                                <div class="prt-sep"> - </div>
                                <span>
                                    <a title="Blog" href="{{ route('newsroom') }}">News Room</a>
                                </span>
                                <div class="prt-sep"> - </div>
                                <span>{{ $newsrooms->title }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page-title end -->

    <!-- ==================== Start Blog ==================== -->

    <section class="sidebar prt-sidebar-left prt-row">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="single-blog">
                        @isset($newsrooms->image)
                            <div class="thumb" style="position: relative; overflow: hidden; border-radius: 8px;">
                                <img src="{{ asset('backend/images/newsroom/' . $newsrooms->image) }}" alt="{{ $newsrooms->title }}" class="w-100" onerror="this.onerror=null; this.src='{{ asset('frontend/img/pg1.jpg') }}'" style="transition: transform 0.3s ease;">
                            </div>
                        @endisset
                        <div class="content pt-4">
                            <span class="post-date">
                                <i class="fa fa-calendar" style="margin-right: 5px;"></i>
                                {{ date('d F Y', strtotime($newsrooms->created_at)) }}
                            </span>
                            <h2 class="mt-3">
                                {{ $newsrooms->title }}
                            </h2>
                            <p>
                                {!! $newsrooms->description !!}
                            </p>
                        </div>
                    </div>

                </div>

                <div class="col-lg-4 widget-area sidebar-left">
                    <div class="prt-blog-sidebar-content">

                        <aside class="widget widget-recent-post with-title">
                            <h3 class="widget-title">Related Posts</h3>
                            <ul class="widget-post prt-recent-post-list">
                                @foreach ($related as $related_newsroom)
                                    <li>
                                        <div class="post-img">
                                            <img width="80" height="80"
                                                src="{{ asset('backend/images/newsroom/' . $related_newsroom->image) }}"
                                                alt="{{ $related_newsroom->title }}">
                                        </div>
                                        <div class="post-detail">
                                            <a
                                                href="{{ route('newsrooms', $related_newsroom->slug) }}">{{ $related_newsroom->title }}</a>
                                            <span
                                                class="post-date">{{ date('d F Y', strtotime($newsrooms->created_at)) }}</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </aside>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ==================== End Blog ==================== -->
@endsection
