@extends('frontend.layouts.app')
@section('content')
    <!-- page-title -->
    <div class="prt-titlebar-wrapper prt-bg about-img">
        <div class="prt-titlebar-wrapper-bg-layer prt-bg-layer"></div>
        <div class="prt-titlebar-wrapper-inner">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12">
                        <div class="prt-page-title-row-heading">
                            <div class="page-title-heading">
                                <h2 class="title">Business</h2>
                            </div>
                            <div class="breadcrumb-wrapper">
                                <i class="flaticon-home"></i>
                                <span>
                                    <a title="Homepage" href="/">Home</a>
                                </span>
                                <div class="prt-sep"> - </div>
                                <span>{{ $service->title }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page-title end -->

    <!-- ==================== Start Blog ==================== -->

    <section class="sidebar prt-sidebar-left prt-row">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="single-service">
                        {{-- @isset($service->image)
                            <div class="thumb">
                                <img src="{{ asset('backend/images/services/' . $service->image) }}" alt="{{ $service->title }}"
                                    class="w-100" onerror="this.onerror=null; this.src='{{ asset('frontend/img/pg1.jpg') }}'">
                            </div>
                        @endisset --}}
                        <div class="content">
                            <h2>{{ $service->title }}</h2>
                            {!! $service->description !!}
                        </div>
                        <a class="prt-btn prt-btn-size-sm prt-btn-shape-rounded prt-btn-style-fill prt-btn-color-dark"
                            href="{{ $service->link }}" target="_blank"> Visit {{ $service->title }} &nbsp;<i
                                class="fa fa-angle-right"></i></a>
                    </div>
                </div>

                <div class="col-lg-4 widget-area sidebar-left">
                    <div class="prt-service-sidebar-content">

                        <aside class="widget widget-recent-post with-title">
                            <h3 class="widget-title">More Business </h3>
                            <ul class="widget-post prt-recent-post-list">
                                @foreach ($services as $related)
                                    <li>
                                        <div class="post-img">
                                            <img width="80" height="80"
                                                src="{{ asset('backend/images/services/' . $related->image) }}"
                                                alt="{{ $related->title }}">
                                        </div>
                                        <div class="post-detail">
                                            <a
                                                href="{{ route('service-detail', $related->slug) }}">{{ $related->title }}</a>
                                                <span class="post-date">Visit Website</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </aside>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ==================== End Blog ==================== -->
@endsection
