@extends('frontend.layouts.app')
@section('content')
    <!-- page-title -->
    <div class="prt-titlebar-wrapper prt-bg about-img">
        <div class="prt-titlebar-wrapper-bg-layer prt-bg-layer"></div>
        <div class="prt-titlebar-wrapper-inner">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12">
                        <div class="prt-page-title-row-heading">
                            <div class="page-title-heading">
                                <h2 class="title">News Rooms</h2>
                            </div>
                            <div class="breadcrumb-wrapper">
                                <i class="flaticon-home"></i>
                                <span>
                                    <a title="Homepage" href="/">Home</a>
                                </span>
                                <div class="prt-sep"> - </div>
                                <span>News Rooms</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page-title end -->

    <!-- ==================== Start about ==================== -->

    <section class="blog-pg prt-row">
        <div class="container">
            <div class="row">
                @foreach ($newsrooms as $newsroom)
                    <div class="col-md-4 mb-4">
                        <div class="blog-card">
                            <div class="blog-thumbnail">
                                <img src="{{ asset('../backend/images/newsroom/' . $newsroom->image) }}" class="w-100 rounded-lg"
                                    alt="{{ $newsroom->title }}">
                            </div>
                            <div class="blog-content">
                                <a href="{{ route('newsrooms', $newsroom->slug) }}">
                                    <h5 class="blog-title">{{ $newsroom->title }}</h5>
                                </a>
                                <p class="blog-description">{{ $newsroom->short_description }}</p>
                                <div class="blog-footer">
                                    <a class="btn-read-more" href="{{ route('newsrooms', $newsroom->slug) }}">Read More →</a>
                                    <span class="post-date"><i class="fa fa-calendar"></i>
                                        {{ date('d F Y', strtotime($newsroom->created_at)) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- ==================== End Blog ==================== -->
@endsection
