@php

    $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();

@endphp

<!-- footer start -->
<footer class="footer widget-footer clearfix">
    <div class="second-footer prt-bgimage-yes prt-bg">
        <div class="prt-row-wrapper-bg-layer prt-bg-layer"></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widgte-text">
                            <img src="{{ $setup ? asset('../backend/images/website/' . $setup->footer_logo) : '' }}"
                                width="250" alt="Logo">
                            <hr>
                            <span class="text-white">
                                {!! $setup ? $setup->about_footer : '' !!}
                            </span>
                        </div>
                        <div class="widgte-text">
                            <div class="tollfree-img">
                                <img src="{{ asset('../frontend/images/logo/24-hr.png') }}" width="50"
                                    alt="Logo">
                                <span class="text-danger">Toll Free : </span><a href="tel:+91-{{ $setup ? $setup->contact_phone_1 : '' }}"
                                    class="toll-no">+91-{{ $setup ? $setup->contact_phone_1 : '' }}</a>
                            </div>
                        </div>
                        <div class="widget_social">
                            <div class="social-icons social-hover">
                                <ul class="social-icons d-flex">
                                    <li>
                                        <a class="prt-social-instagram"
                                            href="{{ $setup ? $setup->instagram_link : '' }}" target="_blank"><i
                                                class="icon-instagram"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-facebook" href="{{ $setup ? $setup->facebook_link : '' }}"
                                            target="_blank"><i class="icon-facebook"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-twitter" href="{{ $setup ? $setup->twitter_link : '' }}"
                                            target="_blank"><i class="icon-twitter"></i></a>
                                    </li>

                                    <li>
                                        <a class="prt-social-linkedin" href="{{ $setup ? $setup->linkedin_link : '' }}"
                                            target="_blank"><i class="icon-linkedin"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-youtube" href="{{ $setup ? $setup->youtube_link : '' }}"
                                            target="_blank"><i class="icon-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Quick Links</h3>
                            </div>
                            <ul class="menu-footer-quick-links">
                                <li><a href="{{ route('about') }}"><i class="fa fa-angle-right"></i>About Us</a></li>
                                <li><a href="{{ route('blog') }}"><i class="fa fa-angle-right"></i>Our Blogs </a></li>
                                <li><a href="#"><i class="fa fa-angle-right"></i>Careers </a></li>
                                <li><a href="{{ route('contact') }}"><i class="fa fa-angle-right"></i>Contact Us </a>
                                </li>
                                <li><a href="{{ route('privacy') }}"><i class="fa fa-angle-right"></i>Privacy Policy </a></li>
                                <li><a href="{{ route('terms') }}"><i class="fa fa-angle-right"></i>Terms & Conditions </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Bank Details</h3>
                            </div>
                            <ul class="menu-footer-quick-links">
                                <p>{!! $setup->bank_detail !!}</p>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget-title">
                        <h3>Get In Touch</h3>
                    </div>
                    <div class="res-767-pb-18">
                        <p><i class="fa fa-map-marker "></i>&nbsp; {!! $setup ? $setup->contact_address : '' !!}</p>
                        <p><i class="fa fa-map-marker "></i>&nbsp; {!! $setup ? $setup->contact_address_2 : '' !!}</p>
                        <p><i class="fa fa-phone"></i>&nbsp;
                            <a href="tel:+91-{{ $setup ? $setup->contact_phone_3 : '' }}">+91-{{ $setup ? $setup->contact_phone_3 : '' }}</a>,
                            <a href="tel:+91-{!! $setup ? $setup->contact_phone_4 : '' !!}">{!! $setup ? $setup->contact_phone_4 : '' !!}</a>
                        </p>
                        <p><i class="fa fa-envelope"></i>&nbsp;
                            <a href="mailto:{{ $setup ? $setup->contact_email_1 : '' }}">{{ $setup ? $setup->contact_email_1 : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bottom-footer-text prt-bg copyright">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="text-left">
                        <span class="cpy-text"> ©
                            {!! $setup ? $setup->copyright_text : '' !!} All Rights Reserved. Developed By <a
                                href="https://techuptechnologies.com/" target="_blank">Techup Technologies</a></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer><!-- footer end -->

<!-- Start OnClick Modal -->
<div class="modal" id="myModal" data-bs-keyboard="false" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Consultation Now</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa fa-times"
                        aria-hidden="true"></i></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <form action="{{ route('contactform') }}" class="contact_form clearfix" method="post">
                        @csrf
                        @if ($message = Session::get('success'))
                            <div class="alert alert-success">
                                <p>{{ $message }}</p>
                            </div>
                        @endif
                        <div class="row">
                            <form action="{{ route('contactform') }}" class="contact_form clearfix" method="post">
                                @csrf
                                @if ($message = Session::get('success'))
                                    <div class="alert alert-success">
                                        <p>{{ $message }}</p>
                                    </div>
                                @endif
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" name="name" class="form-control"
                                            value="{{ old('name') }}" placeholder="Your Name *" required="">
                                        @if ($errors->has('name'))
                                            <div class="text-danger">{{ $errors->first('name') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-6">
                                        <input type="email" name="email" class="form-control"
                                            value="{{ old('email') }}" placeholder="Your Email *" required="">
                                        @if ($errors->has('email'))
                                            <div class="text-danger">{{ $errors->first('email') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-6">
                                        <input type="number" name="number" class="form-control"
                                            value="{{ old('number') }}" maxlength="10" pattern="[0-9]{10}"
                                            placeholder="Your Number *" required="">
                                        @if ($errors->has('number'))
                                            <div class="text-danger">{{ $errors->first('number') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="services" class="form-control"
                                            value="{{ old('services') }}" placeholder="Service You Need *"
                                            required="">
                                        @if ($errors->has('services'))
                                            <div class="text-danger">{{ $errors->first('services') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="city" class="form-control"
                                            value="{{ old('city') }}" placeholder="Your City *" required="">
                                        @if ($errors->has('city'))
                                            <div class="text-danger">{{ $errors->first('city') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-6">
                                        <input type="text" name="state" class="form-control"
                                            value="{{ old('state') }}" placeholder="Your State *" required="">
                                        @if ($errors->has('state'))
                                            <div class="text-danger">{{ $errors->first('state') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <textarea name="message" class="form-control textarea" placeholder="Type Your Message Here . . .">{{ old('message') }}</textarea>
                                    </div>
                                    <div class="mt-5 text-center">
                                        <button
                                            class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor"
                                            type="submit" value="submit">Submit Here <i
                                                class="fa fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- End OnClick Modal -->


<!-- back-to-top start -->
<a id="totop" href="#top">
    <i class="fa fa-angle-up"></i>
</a>
<!-- back-to-top end -->
@if ($setup && $setup->contact_phone_1)
    <a href="tel:+91-{{ $setup->contact_phone_1 }}" class="float1" target="_blank"> <i
            class="flaticon-phone-call my-float"></i> </a>
@endif
@if ($setup && $setup->whatsapp_link)
    <a href="https://api.whatsapp.com/send?phone={{ $setup->whatsapp_link }}&amp;text=" class="float"
        target="_blank">
        <i class="fa fa-whatsapp my-float"></i></a>
@endif

</div><!-- page end -->
<!-- Javascript -->
<script src="{{ asset('frontend/js/jquery-3.6.0.min.js') }}"></script>
<script src="{{ asset('frontend/js/jquery-migrate-3.3.2.min.js') }}"></script>
<script src="{{ asset('frontend/js/bootstrap.bundle.js') }}"></script>
<script src="{{ asset('frontend/js/aos.js') }}"></script>
<script src="{{ asset('frontend/js/jquery-validate.js') }}"></script>
<script src="{{ asset('frontend/js/jquery.prettyPhoto.js') }}"></script>
<script src="{{ asset('frontend/js/slick.min.js') }}"></script>
<script src="{{ asset('frontend/js/jquery-waypoints.js') }}"></script>
<script src="{{ asset('frontend/js/numinate.min.js') }}"></script>
<script src="{{ asset('frontend/js/imagesloaded.min.js') }}"></script>
<script src="{{ asset('frontend/js/jquery-isotope.js') }}"></script>
<script src="{{ asset('frontend/js/jquery.twentytwenty.js') }}"></script>
<script src="{{ asset('frontend/js/circle-progress.min.js') }}"></script>
<script src="{{ asset('frontend/js/main.js') }}"></script>

</body>

</html>
