@extends('frontend.layouts.app')
@section('content')
    <!-- page-title -->
    <div class="prt-titlebar-wrapper prt-bg about-img">
        <div class="prt-titlebar-wrapper-bg-layer prt-bg-layer"></div>
        <div class="prt-titlebar-wrapper-inner">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12 text-center">
                        <div class="prt-page-title-row-heading">
                            <div class="page-title-heading">
                                <h2 class="title">Contact Us</h2>
                            </div>
                            <div class="breadcrumb-wrapper">
                                <i class="flaticon-home"></i>
                                <span>
                                    <a title="Homepage" href="/">Home</a>
                                </span>
                                <div class="prt-sep"> - </div>
                                <span>Contact Us</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page-title end -->

    <!--site-main start-->
    <div class="site-main">

        <!-- contact-us-iconbox-section -->
        <section class="prt-row contact-us-iconbox-section clearfix">
            <div class="container">
                <div class="row g-0 prt-vertical_sep">
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="featured-icon-box icon-align-top-content style19">
                            <div class="contact-box">
                                <div class="featured-icon">
                                    <div class="prt-icon">
                                        <i class="flaticon-phone-call"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>call us on</h3>
                                    </div>
                                    <div class="featured-desc">
                                        @if ($setup && $setup->contact_phone_2)
                                            <a
                                                href="tel:+91-{{ $setup->contact_phone_1 }}">+91-{{ $setup->contact_phone_1 }}</a>,
                                        @endif
                                        @if ($setup && $setup->contact_phone_2)
                                            <a href="tel:+91-{!! $setup->contact_phone_2 !!}">{!! $setup->contact_phone_2 !!}</a><br>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="featured-icon-box icon-align-top-content style19">
                            <div class="contact-box">
                                <div class="featured-icon">
                                    <div class="prt-icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Email</h3>
                                    </div>
                                    <div class="featured-desc">
                                        @if ($setup && $setup->contact_email_1)
                                            <a href="mailto:{{ $setup->contact_email_1 }}">{{ $setup->contact_email_1 }}</a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="featured-icon-box icon-align-top-content style19">
                            <div class="contact-box">
                                <div class="featured-icon">
                                    <div class="prt-icon">
                                        <i class="fa fa-whatsapp"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Whatsapp</h3>
                                    </div>
                                    <div class="featured-desc">
                                        @if ($setup && $setup->whatsapp_link)
                                            <a href="https://api.whatsapp.com/send?phone={{ $setup->whatsapp_link }}&amp;text="
                                                target="_blank">+91-{{ $setup->whatsapp_link }}</a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="featured-icon-box icon-align-top-content style19">
                            <div class="contact-box">
                                <div class="featured-icon">
                                    <div class="prt-icon">
                                        <i class="flaticon-location"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Office Address</h3>
                                    </div>
                                    <div class="featured-desc contact-address">
                                        @if ($setup && $setup->contact_address)
                                            <span>{!! $setup->contact_address !!}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Office Address 2</h3>
                                    </div>
                                    <div class="featured-desc contact-address">
                                        @if ($setup && $setup->contact_address_2)
                                            <span>{!! $setup->contact_address_2 !!}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Office Address 3</h3>
                                    </div>
                                    <div class="featured-desc contact-address">
                                        @if ($setup && $setup->contact_address_3)
                                            <span>{!! $setup->contact_address_3 !!}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Office Address 4</h3>
                                    </div>
                                    <div class="featured-desc contact-address">
                                        @if ($setup && $setup->contact_address_4)
                                            <span>{!! $setup->contact_address_4 !!}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- contact-us-iconbox-section-end -->

        <!-- contact-form-section -->
        <section class="contact-us-contact-form-section clearfix">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 mb-20">
                        <!-- map-start -->
                        <div class="mapouter">
                            <div class="gmap_canvas">
                                <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0"
                                    marginwidth="0"
                                    src="https://maps.google.com/maps?width=600&amp;height=480&amp;hl=en&amp;q=H.NO. - B 32/16-C-1 (H.O) Nariya, Lanka Varanasi - (U.P) - 221005 (Near Superspacialist Hospital, BHU)&amp;t=&amp;z=15&amp;ie=UTF8&amp;iwloc=B&amp;output=embed">
                                </iframe>
                            </div>
                            <style>
                                .mapouter {
                                    position: relative;
                                    text-align: right;
                                    width: 100%;
                                    height: 480px;
                                }

                                .gmap_canvas {
                                    overflow: hidden;
                                    background: none !important;
                                    width: 100%;
                                    height: 480px;
                                }

                                .gmap_iframe {
                                    height: 480px !important;
                                }
                            </style>
                        </div>
                        <!-- map end -->
                    </div>

                    <div class="col-lg-6">
                        <div class="registration_forn">
                            <form action="{{ route('contactform') }}" class="contact_form clearfix" method="post">
                                @csrf
                                @if ($message = Session::get('success'))
                                    <div class="alert alert-success">
                                        <p>{{ $message }}</p>
                                    </div>
                                @endif
                                <div class="row">
                                    <div class="col-md-12">
                                        <input type="text" name="name" class="form-control"
                                            value="{{ old('name') }}" placeholder="Your Name *" required="">
                                        @if ($errors->has('name'))
                                            <div class="text-danger">{{ $errors->first('name') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <input type="email" name="email" class="form-control"
                                            value="{{ old('email') }}" placeholder="Your Email *" required="">
                                        @if ($errors->has('email'))
                                            <div class="text-danger">{{ $errors->first('email') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <input type="number" name="number" class="form-control"
                                            value="{{ old('number') }}" placeholder="Your Number *" required="">
                                        @if ($errors->has('number'))
                                            <div class="text-danger">{{ $errors->first('number') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <input type="text" name="subject" class="form-control"
                                            value="{{ old('subject') }}" placeholder="Your Subject *">
                                        @if ($errors->has('subject'))
                                            <div class="text-danger">{{ $errors->first('subject') }}</div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <textarea name="message" class="form-control textarea" placeholder="Type Your Message Here . . .">{{ old('message') }}</textarea>
                                    </div>
                                    <div class="mt-5">
                                        <button
                                            class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor"
                                            type="submit" value="submit">Submit Here <i
                                                class="fa fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- contact-form-section-end -->

    </div><!-- site-main end-->
@endsection
