@extends('backend.layouts.app')
@section('content')
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Update Website Setup</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->

                <div class="card">
                    <div class="card-body">
                        @if (isset($websiteSetup) && isset($websiteSetup->id))
                            <form action="{{ route('website.update', $websiteSetup->id) }}" method="POST"
                                enctype="multipart/form-data" class="needs-validation" novalidate>
                                @method('PUT')
                            @else
                                <form action="{{ route('website.store') }}" method="POST" enctype="multipart/form-data"
                                    class="needs-validation" novalidate>
                        @endif
                        @csrf

                        <div class="row">
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Contact Phone</label>
                                <input type="text" class="form-control" name="contact_phone_1"
                                    oninput="validatePhone(this)"
                                    @if (isset($websiteSetup)) value="{{ old('contact_phone_1', optional($websiteSetup)->contact_phone_1) }}" @endif>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Contact Phone 2</label>
                                <input type="text" class="form-control" name="contact_phone_2"
                                    oninput="validatePhone(this)"
                                    @if (isset($websiteSetup)) value="{{ old('contact_phone_2', optional($websiteSetup)->contact_phone_2) }}" @endif>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Contact Phone 3</label>
                                <input type="text" class="form-control" name="contact_phone_3"
                                    oninput="validatePhone(this)"
                                    @if (isset($websiteSetup)) value="{{ old('contact_phone_3', optional($websiteSetup)->contact_phone_3) }}" @endif>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Contact Phone 4</label>
                                <input type="text" class="form-control" name="contact_phone_4"
                                    oninput="validatePhone(this)"
                                    @if (isset($websiteSetup)) value="{{ old('contact_phone_4', optional($websiteSetup)->contact_phone_4) }}" @endif>
                            </div>
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Contact Email</label>
                                <input type="email" class="form-control" name="contact_email_1"
                                    @if (isset($websiteSetup)) value="{{ old('contact_email_1', optional($websiteSetup)->contact_email_1) }}" @endif>
                            </div>
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Contact Email 2</label>
                                <input type="email" class="form-control" name="contact_email_2"
                                    @if (isset($websiteSetup)) value="{{ old('contact_email_2', optional($websiteSetup)->contact_email_2) }}" @endif>
                            </div>
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Whatsapp</label>
                                <div class="input-group flatpickr">
                                    <span class="input-group-text input-group-addon bg-success" data-toggle><i
                                            class="text-white bx bxl-whatsapp"></i></span>
                                    <input type="text" class="form-control" name="whatsapp_link"
                                        oninput="validatePhone(this)"
                                        @if (isset($websiteSetup)) value="{{ old('whatsapp_link', optional($websiteSetup)->whatsapp_link) }}" @endif>
                                </div>
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Facebook Link</label>
                                <div class="input-group flatpickr">
                                    <span class="input-group-text input-group-addon bg-primary" data-toggle><i
                                            class="text-white bx bxl-facebook"></i></span>
                                    <input type="text" class="form-control" name="facebook_link"
                                        @if (isset($websiteSetup)) value="{{ old('facebook_link', optional($websiteSetup)->facebook_link) }}" @endif>
                                </div>
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Twitter Link</label>
                                <div class="input-group flatpickr">
                                    <span class="input-group-text input-group-addon bg-info" data-toggle><i
                                            class="text-white bx bxl-twitter"></i></span>
                                    <input type="text" class="form-control" name="twitter_link"
                                        @if (isset($websiteSetup)) value="{{ old('twitter_link', optional($websiteSetup)->twitter_link) }}" @endif>
                                </div>
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Instagram Link</label>
                                <div class="input-group flatpickr">
                                    <span class="input-group-text input-group-addon bg-danger" data-toggle><i
                                            class="text-white bx bxl-instagram"></i></span>
                                    <input type="text" class="form-control" name="instagram_link"
                                        @if (isset($websiteSetup)) value="{{ old('instagram_link', optional($websiteSetup)->instagram_link) }}" @endif>
                                </div>
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Linkedin Link</label>
                                <div class="input-group flatpickr">
                                    <span class="input-group-text input-group-addon bg-primary" data-toggle><i
                                            class="text-white bx bxl-linkedin"></i></span>
                                    <input type="text" class="form-control" name="linkedin_link"
                                        @if (isset($websiteSetup)) value="{{ old('linkedin_link', optional($websiteSetup)->linkedin_link) }}" @endif>
                                </div>
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Youtube Link</label>
                                <div class="input-group flatpickr">
                                    <span class="input-group-text input-group-addon bg-danger" data-toggle><i
                                            class="text-white bx bxl-youtube"></i></span>
                                    <input type="text" class="form-control" name="youtube_link"
                                        @if (isset($websiteSetup)) value="{{ old('youtube_link', optional($websiteSetup)->youtube_link) }}" @endif>
                                </div>
                            </div>

                            <div class="mb-3 col-md-12">
                                <label class="form-label">Copyright Text</label>
                                <input type="text" class="form-control" name="copyright_text"
                                    @if (isset($websiteSetup)) value="{{ old('copyright_text', optional($websiteSetup)->copyright_text) }}" @endif>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label class="form-label">Contact Address </label>
                                <textarea class="form-control" id="example-textarea" name="contact_address" rows="5">
                                    @if (isset($websiteSetup))
                                        {{ old('contact_address', optional($websiteSetup)->contact_address) }}
                                    @endif
                                </textarea>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label class="form-label">Contact Address 2 </label>
                                <textarea class="form-control" id="example-textarea" name="contact_address_2" rows="5">
                                    @if (isset($websiteSetup))
                                        {{ old('contact_address_2', optional($websiteSetup)->contact_address_2) }}
                                    @endif
                                </textarea>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label class="form-label">Contact Address 3</label>
                                <textarea class="form-control" id="example-textarea" name="contact_address_3" rows="5">
                                    @if (isset($websiteSetup))
                                        {{ old('contact_address_3', optional($websiteSetup)->contact_address_3) }}
                                    @endif
                                </textarea>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label class="form-label">Contact Address 4</label>
                                <textarea class="form-control" id="example-textarea" name="contact_address_4" rows="5">
                                    @if (isset($websiteSetup))
                                        {{ old('contact_address_4', optional($websiteSetup)->contact_address_4) }}
                                    @endif
                                </textarea>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label class="form-label">About Footer</label>
                                <textarea class="ckeditor" id="example-textarea" name="about_footer" rows="5">
                                    @if (isset($websiteSetup))
                                        {{ old('about_footer', optional($websiteSetup)->about_footer) }}
                                    @endif
                                </textarea>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label class="form-label">Bank Detail</label>
                                <textarea class="ckeditor" id="example-textarea" name="bank_detail" rows="5">
                                    @if (isset($websiteSetup))
                                        {{ old('bank_detail', optional($websiteSetup)->bank_detail) }}
                                    @endif
                                </textarea>
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Logo</label>
                                <input type="file" id="logo" name="logo" class="form-control">
                                @if (isset($websiteSetup))
                                    <img class="mt-2" id="logo_img"
                                        src="{{ URL::asset('backend/images/website/' . old('logo', optional($websiteSetup)->logo)) }}"
                                        onerror="this.onerror=null; this.src='{{ asset('backend/images/no_image.png') }}'"
                                        style="width: 25%;" />
                                @else
                                    <img class="mt-2" id="logo_img" src="{{ asset('backend/images/no_image.png') }}"
                                        onerror="this.onerror=null;this.src='{{ asset('backend/images/no_image.png') }}'"
                                        style="width:25%;">
                                @endif
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Footer Logo</label>
                                <input type="file" id="footer_logo" name="footer_logo" class="form-control">
                                @if (isset($websiteSetup))
                                    <img class="mt-2" id="foot_logo_img"
                                        src="{{ URL::asset('backend/images/website/' . old('footer_logo', optional($websiteSetup)->footer_logo)) }}"
                                        onerror="this.onerror=null; this.src='{{ asset('backend/images/no_image.png') }}'"
                                        style="width: 25%;" />
                                @else
                                    <img class="mt-2" id="foot_logo_img" src="{{ asset('backend/images/no_image.png') }}"
                                        onerror="this.onerror=null;this.src='{{ asset('backend/images/no_image.png') }}'"
                                        style="width:25%;">
                                @endif
                            </div>

                            <div class="mb-3 col-md-4">
                                <label class="form-label">Favicon</label>
                                <input type="file" id="favicon" name="favicon" class="form-control">
                                @if (isset($websiteSetup))
                                    <img class="mt-2" id="favicon_img"
                                        src="{{ URL::asset('backend/images/website/' . old('favicon', optional($websiteSetup)->favicon)) }}"
                                        onerror="this.onerror=null; this.src='{{ asset('backend/images/no_image.png') }}'"
                                        style="width:10%;" />
                                @else
                                    <img class="mt-2" id="favicon_img"
                                        src="{{ asset('backend/images/no_image.png') }}"
                                        onerror="this.onerror=null;this.src='{{ asset('backend/images/no_image.png') }}'"
                                        style="width:10%;">
                                @endif
                            </div>

                            <div class="mb-3 col-md-4">
                                <button class="btn btn-primary" type="submit">Submit</button>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        logo.onchange = evt => {
            const [file] = logo.files
            if (file) {
                logo_img.src = URL.createObjectURL(file)
            }
        }

        footer_logo.onchange = evt => {
            const [file] = footer_logo.files
            if (file) {
                foot_logo_img.src = URL.createObjectURL(file)
            }
        }

        favicon.onchange = evt => {
            const [file] = favicon.files
            if (file) {
                favicon_img.src = URL.createObjectURL(file)
            }
        }
    </script>
@endsection
