@extends('backend.layouts.app')
@section('content')
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="#" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-reply me-1"></i> All Gallery
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Gallery</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($gallerys as $data)
                                            <tr>
                                                <td class="table-user">
                                                    <img id="blah"
                                                        src="{{ URL::asset('backend/images/gallery/' . $data->image) }}"
                                                        alt="your image"
                                                        onerror="this.onerror=null; this.src='backend/images/no_image.svg'" />
                                                </td>
                                                <td>{{ $data->title }}</td>

                                                <td class="table-action d-flex">

                                                    <a href="{{ route('gallery.edit', $data->id) }}" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="{{ route('gallery.destroy', $data->id) }}" method="POST">
                                                        @method('DELETE')
                                                        @csrf
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                @if (isset($gallery) && isset($gallery->id))
                                    <form action="{{ route('gallery.update', $gallery->id) }}" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        @method('PUT')
                                    @else
                                        <form action="{{ route('gallery.store') }}" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                @endif

                                @csrf


                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Course Name</label>
                                        <input type="text" class="form-control" name="title"
                                            @if (isset($gallery)) value="{{ old('title', optional($gallery)->title) }}" @endif>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="image" class="form-control">
                                        @if (isset($gallery))
                                            <img id="img" src="{{ URL::asset('backend/images/gallery/' . old('image', optional($gallery)->image)) }}"
                                                onerror="this.onerror=null; this.src='../backend/images/no_image.png'"
                                                style="width: 35%;" />
                                        @else
                                            <img class="mt-2" id="img" src="{{asset('backend/images/no_image.png')}}" onerror="this.onerror=null;this.src='{{asset('backend/images/no_image.png')}}'" height="100px" width="100px">
                                        @endif
                                    </div>



                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>
@endsection
