 @extends('backend.layouts.app')
 @section('content')
     <div class="content-page">
         <div class="content">

             <!-- Start Content-->
             <div class="container-fluid">

                 <!-- start page title -->
                 <div class="row">
                     <div class="col-12">
                         <div class="page-title-box">
                             <div class="page-title-right">
                                 <ol class="breadcrumb m-0">
                                     <a href="{{ route('enquiry.index') }}" class="btn btn-sm btn-dark waves-effect">
                                         <i class="mdi mdi-plus me-1"></i> All enquiry
                                     </a>
                                 </ol>
                             </div>
                             <h4 class="page-title">All Enquiry</h4>
                         </div>
                     </div>
                 </div>

                 <!-- end page title -->

                 <div class="row">
                     <div class="card">
                         <div class="card-body">
                             <table class="table table-striped table-centered mb-0">
                                 <thead>
                                     <tr>
                                         <th>Name</th>
                                         <th>Phone Number</th>
                                         <th>Email</th>
                                         <th>Subject</th>
                                         <th>Message</th>
                                         <th>Action</th>
                                     </tr>
                                 </thead>
                                 <tbody>

                                     @foreach ($enquirys as $enquiry)
                                         <tr>

                                             <td>{{ $enquiry->name }}</td>
                                             <td>{{ $enquiry->number }}</td>
                                             <td>{{ $enquiry->email }}</td>
                                             <td>{{ $enquiry->subject }}</td>
                                             @isset($enquiry->message)
                                                 <td>{{ $enquiry->message }}</td>
                                             @else
                                                 <td class="text-danger">N/A</td>
                                             @endisset
                                             <td>

                                                 <form action="{{ route('enquiry.destroy', $enquiry->id) }}" method="POST">
                                                     @method('DELETE')
                                                     @csrf
                                                     <button class="btn text-danger btn-sm" onclick="return areyousure();  "
                                                         title="Delete" class="action-icon">
                                                         <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                 </form>
                                             </td>
                                         </tr>
                                     @endforeach

                                 </tbody>
                             </table>
                         </div>
                     </div>
                 </div>

             </div>
             <!-- container -->

         </div>
         <!-- content -->

     </div>

     </div>
     <!-- END wrapper -->
 @endsection
