@extends('backend.layouts.app')
@section('content')

<div class="content-page">
    <div class="content">

          <!-- Start Content-->
          <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <a href="{{ route('service.index') }}" class="btn btn-sm btn-dark waves-effect">
                                    <i class="dripicons-reply me-1"></i> Back To Courses
                                </a>
                            </ol>
                        </div>
                        <h4 class="page-title">Add Courses</h4>
                    </div>
                </div>
            </div>

            <!-- end page title -->

                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('service.store') }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                            @csrf
                          <div class="row">
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Select Category</label>
                                <select class="form-select" id="example-select" name="course_category_id" required>
                                    <option>Select Here</option>
                                    @foreach($category as $categories)
                                        <option value="{{ $categories->id }}">{{ $categories->course_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Service Name</label>
                                <input type="text" class="form-control" name="course_name" value="{{ old('course_name') }}" placeholder="Service Name" required>
                            </div>
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Service Fees</label>
                                <input type="text" class="form-control" name="course_fees" value="{{ old('course_fees') }}" placeholder="Service Fees">
                            </div>
                            <div class="mb-3 col-md-12">
                                <label class="form-label">Description</label>
                                <textarea id="snow-editor" class="ckeditor"  name="course_description"  placeholder="About Description" rows="8">{{ old('course_description') }}</textarea>
                            </div>
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Image</label>
                                <input type="file" id="image" name="course_img" class="form-control">
                                <img class="mt-2" id="img" src="{{asset('backend/images/no_image.png')}}" onerror="this.onerror=null;this.src='{{asset('backend/images/no_image.png')}}'" height="100px" width="100px">
                            </div>
                            <div class="mb-3 col-md-12">
                               <button class="btn btn-primary" type="submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- container -->
    </div>
    <!-- content -->

</div>

</div>
<!-- END wrapper -->

<script>
    image.onchange = evt => {
        const [file] = image.files
        if (file) {
            img.src = URL.createObjectURL(file)
        }
    }
</script>

@endsection
