@extends('backend.layouts.app')
@section('content')

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="{{route('service.create')}}" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-plus me-1"></i> Add Service
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Service Category</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                   <div class="col-md-7">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped table-centered mb-0">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Category Name</th>
                                        <th>About Course</th>
                                        {{-- <th>Active</th> --}}
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($coursecat as $cat)

                                        <tr>
                                            <td class="table-user">
                                                <img id="blah" src="{{ URL::asset('backend/images/coursecat/' . $cat->course_img) }}"
                                                alt="your image" onerror="this.onerror=null; this.src='{{asset('backend/images/no_image.svg')}}'"/>
                                            </td>
                                            <td>{{$cat->course_name}}</td>
                                            <td>{!!$cat->course_description!!}</td>
                                            {{-- <td>
                                                <!-- Switch-->
                                                <div>
                                                    <input type="checkbox" data-id="{{$cat->id}}" id="switch_{{$cat->id}}" class="toggle-classs" value="{{$cat->id}}" {{ $cat->status ? 'checked' : '' }} data-switch="success" />
                                                    <label for="switch_{{$cat->id}}"  data-on-label="Yes" data-off-label="No"
                                                        class="mb-0 d-block"></label>
                                                </div>
                                            </td> --}}
                                            <td class="table-action d-flex">

                                                <a href="{{ route('service-category.edit',$cat->id) }}" class="action-icon">
                                                     <i class="mdi mdi-pencil"></i></a>

                                                <form action="{{ route('service-category.destroy', $cat->id) }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn text-danger btn-sm"
                                                        onclick="return areyousure();  " title="Delete"  class="action-icon">
                                                         <i class="mdi mdi-delete"
                                                            aria-hidden="true"></i> </button>
                                                </form>
                                            </td>
                                        </tr>


                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                   </div>
                <div class="col-md-5">
                    <div class="card">
                        <div class="card-body">
                            @if (isset($category) && isset($category->id))
                                <form action="{{ route('service-category.update', $category->id) }}" method="POST"
                                enctype="multipart/form-data" class="needs-validation" novalidate>
                                @method('PUT')
                            @else

                                <form action="{{ route('service-category.store') }}" method="POST"
                                enctype="multipart/form-data" class="needs-validation" novalidate>
                            @endif
                            @csrf

                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Category Name</label>
                                        <input type="text" class="form-control" name="course_name"
                                         @if(isset($category))value="{{ old('course_name', optional($category)->course_name) }}"@endif>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="course_img" class="form-control">
                                        @if(isset($category))<img id="img" src="{{ URL::asset('backend/images/coursecat/' . old('course_img', optional($category)->course_img))}}"
                                                onerror="this.onerror=null; this.src='{{asset('backend/images/no_image.png')}}'" style="width: 35%;"/>
                                        @else
                                            <img class="mt-2" id="img" src="{{asset('backend/images/no_image.png')}}" onerror="this.onerror=null;this.src='{{asset('backend/images/no_image.png')}}'" height="100px" width="100px">
                                        @endif
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">About Category</label>
                                        <textarea class="ckeditor" name="course_description" @if (isset($coursecategory)) value="{{ old('course_description')}}" @endif >@isset($category){!!$category->course_description!!} @endisset</textarea>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                       <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
              </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>

    @endsection
