<?php

namespace App\Models;

use App\Models\CourseCategory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Course extends Model
{
    use HasFactory;

    protected $fillable = [
        'course_category_id',
        'course_name',
        'course_img',
        'course_fees',
        'course_fees_type',
        'course_duration',
        'course_eligibility',
        'course_description',
        'slug',
        'status',
        'delete_status',
    ];

    public function category(){
        return $this->belongsTo(CourseCategory::class, 'course_category_id');
    }
}
