<?php

namespace App\Http\Controllers;

use App\Models\WebsiteSetup;
use Illuminate\Http\Request;

class WebsiteSetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $websiteSetup = WebsiteSetup:: Where('delete_status', '0')->first();
        return view('backend.website.index', compact('websiteSetup') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)

    {
        // $request->validate([
        //     'title' => 'required',
        // ]);

        $website=$request->all();

        if($request->file('logo')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->logo->extension();
            $request->logo->move(public_path('backend/images/website'), $imageName);
            $website['logo']=$imageName;
        }

        if($request->file('footer_logo')){
            $imageName2 = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->footer_logo->extension();
            $request->footer_logo->move(public_path('backend/images/website'), $imageName2);
            $website['footer_logo']=$imageName2;
        }

        if($request->file('favicon')){
            $imageName3 = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->favicon->extension();
            $request->favicon->move(public_path('backend/images/website'), $imageName3);
            $website['favicon']=$imageName3;
        }


        // $blog['slug']=\Str::slug($request->title).'-'.rand();
        WebsiteSetup::create($website);


        return redirect()->route('website.index')
        ->with('success','Website Setup Updated successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\WebsiteSetup  $websiteSetup
     * @return \Illuminate\Http\Response
     */
    public function show(WebsiteSetup $websiteSetup)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\WebsiteSetup  $websiteSetup
     * @return \Illuminate\Http\Response
     */
    public function edit(WebsiteSetup $websiteSetup)
    {
        return view('backend/website.index',compact('websiteSetup'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\WebsiteSetup  $websiteSetup
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $websiteSetup = WebsiteSetup::find($id);
        $input=$request->all();

        if($request->file('logo')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->logo->extension();
            $request->logo->move(public_path('backend/images/website'), $imageName);
            $input['logo']=$imageName;
        }

        if($request->file('footer_logo')){
            $imageName2 = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->footer_logo->extension();
            $request->footer_logo->move(public_path('backend/images/website'), $imageName2);
            $input['footer_logo']=$imageName2;
        }

        if($request->file('favicon')){
            $imageName3 = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->favicon->extension();
            $request->favicon->move(public_path('backend/images/website'), $imageName3);
            $input['favicon']=$imageName3;
        }

        $websiteSetup->update($input);

        return redirect()->route('website.index')
        ->with('success','Website Setup updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\WebsiteSetup  $websiteSetup
     * @return \Illuminate\Http\Response
     */
    public function destroy(WebsiteSetup $websiteSetup)
    {
        //
    }

}
