<?php

namespace App\Http\Controllers;

use App\Models\Services;
use Illuminate\Http\Request;

class ServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $servicespage = Services:: Where('delete_status', '0')->latest()->get();
        return view('backend.services.index', compact('servicespage') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $servicespage=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/services'), $imageName);
            $servicespage['image']=$imageName;
        }

        $servicespage['slug']=\Str::slug($request->title).'-'.rand();

        // $blog['slug']=\Str::slug($request->title).'-'.rand();
        Services::create($servicespage);

        return redirect()->route('service.index')
        ->with('success','Service Updated successfully.');


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Services $servicespage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $edit_service = Services::find($id);
        $servicespage = Services:: Where('delete_status', '0')->latest()->get();
        return view('backend.services.index',compact('edit_service','servicespage'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $servicespage = Services::find($id);
        $input=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/services'), $imageName);
            $input['image']=$imageName;
        }


        $servicespage->update($input);

        return redirect()->route('service.index')
        ->with('success','Service updated successfully.');


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $servicespage = Services::where('id', $id)->update(array('delete_status' => 1));
        return redirect()->route('service.index')->with('success','Service deleted successfully');
    }

    public function changeStatus(Request $request)
    {
        $servicespage = Services::find($request->id);
        $servicespage->status = $request->status;
        $servicespage->save();

        return response()->json(['success'=>'Status change successfully.']);
    }
}
