<?php

namespace App\Http\Controllers;

use App\Models\Registration;
use Illuminate\Http\Request;

class RegistrationController extends Controller
{

    public function index($page_name){
        return view('frontend.book-appointment',compact('page_name'));
    }

    public function store(Request $request){

        $registration = new Registration;
        $registration->name = $request->name;
        $registration->email = $request->email;
        $registration->phone = $request->phone;
        $registration->organisation = $request->organisation;
        $registration->designation = $request->designation;
        $registration->page_name = $request->page_name;
        $registration->services = $request->services;
        $registration->save();

        return redirect()->back()->with('success','Form Submitted Successfully!');
    }


    public function show(){
        $registrationform = Registration::orderBy('id','desc')->where('delete_status','0')->paginate(10);
        return view('backend/registration-form.index', compact('registrationform') );
    }


}
