<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function index(){
        $products = Product::where('delete_status','0')->latest()->get();
        return view('backend.product.index', compact('products'));
    }


    public function store(Request $request){
        $product = $request->all();
        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/product'), $imageName);
            $product['image']=$imageName;
        }
        Product::create($product);
        return back()->with('success', 'Product added successfully');
    }

    public function edit(Product $product){
        $products = Product::where('delete_status', '0')->latest()->get();
        return view('backend.product.index', compact('products', 'product'));
    }

    public function update(Request $request, $id){
        $product = Product::find($id);
        $input = $request->all();
        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/product'), $imageName);
            $input['image']=$imageName;
        }
        $product->update($input);
        return redirect()->route('product.index')->with('success', 'Product updated successfully');
    }

    public function destroy($id)
    {
        $product = Product::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('product.index')
                        ->with('success','Product deleted successfully');
    }

    public function changeStatus(Request $request)
    {
        $product = Product::find($request->id);
        $product->status = $request->status;
        $product->save();

        return response()->json(['success'=>'Status change successfully.']);
    }
}
