<?php

namespace App\Http\Controllers;

use App\Models\HomePage;
use Illuminate\Http\Request;

class HomePageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $homepage = HomePage:: Where('delete_status', '0')->first();
        return view('backend.pages.home.index', compact('homepage') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $homepage=$request->all();

        if($request->file('cover_image')){
            $imageName = time().'.'.$request->cover_image->extension();
            $request->cover_image->move(public_path('backend/images/homepage'), $imageName);
            $homepage['cover_image']=$imageName;
        }

        if($request->file('qualification_image')){
            $imageName = time().'.'.$request->qualification_image->extension();
            $request->qualification_image->move(public_path('backend/images/homepage'), $imageName);
            $homepage['qualification_image']=$imageName;
        }

        if($request->file('welcome_image')){
            $imageName = time().'.'.$request->welcome_image->extension();
            $request->welcome_image->move(public_path('backend/images/homepage'), $imageName);
            $homepage['welcome_image']=$imageName;
        }



        // $blog['slug']=\Str::slug($request->title).'-'.rand();
        HomePage::create($homepage);


        return redirect()->route('homepage.index')
        ->with('success','Homepage Updated successfully.');


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(HomePage $homepage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(HomePage $homepage)
    {
        return view('backend/pages.home.index',compact('homepage'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $homepage = HomePage::find($id);
        $input=$request->all();

        if($request->file('cover_image')){
            $imageName = time().'.'.$request->cover_image->extension();
            $request->cover_image->move(public_path('backend/images/homepage'), $imageName);
            $input['cover_image']=$imageName;
        }

        if($request->file('welcome_image')){
            $imageName = time().'.'.$request->welcome_image->extension();
            $request->welcome_image->move(public_path('backend/images/homepage'), $imageName);
            $input['welcome_image']=$imageName;
        }

        if($request->file('qualification_image')){
            $imageName = time().'.'.$request->qualification_image->extension();
            $request->qualification_image->move(public_path('backend/images/homepage'), $imageName);
            $input['qualification_image']=$imageName;
        }

        $homepage->update($input);

        return redirect()->route('homepage.index')
        ->with('success','Homepage updated successfully.');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

    }
}
