<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\Team;
use App\Models\About;
use App\Models\Terms;
use App\Models\Client;
use App\Models\Slider;
use App\Models\Gallery;
use App\Models\Product;
use App\Models\NewsRoom;
use App\Models\Services;
use App\Models\Testimonial;
use App\Models\WebsiteSetup;
use Illuminate\Http\Request;

class FrontController extends Controller
{
    public function homepage(){
        $sliders = Slider::orderBy('id','desc')->where('delete_status','0')->where('status','1')->get();
        $services = Services::where('delete_status','0')->where('status','1')->get();
        $testimonials = Testimonial::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->get();
        $clients = Client::where('delete_status','0')->where('status','1')->latest()->get();
        $blogs = Blog::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->take(3)->get();
        $newsrooms = NewsRoom::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->take(3)->get();
        return view('frontend.index', compact('sliders','services','testimonials','clients','blogs','newsrooms'));
    }

    public function about(){
        $about = About::orderBy('id','desc')->where('delete_status','0')->first();
        return view('frontend.about', compact('about'), ['page_title' => 'About us']);
    }

    // public function service(){
    //     $services = Services::where('delete_status','0')->where('status','1')->latest()->get();
    //     return view('frontend.services', compact('services'));
    // }

    public function serviceDetail($slug){
        $service = Services::where('slug',$slug)->first();
        $services = Services::where('delete_status','0')->where('status','1')->get();
        return view('frontend.service-detail', compact('service','services'), ['page_title' => 'Business']);
    }

    public function product(){
        $products = Product::where('delete_status','0')->where('status','1')->latest()->paginate(9);
        return view('frontend.product', compact('products'));
    }

    public function director(){
        $teams = Team::where('delete_status','0')->where('status','1')->get();
        return view('frontend.directors', compact('teams'), ['page_title' => 'Directors']);
    }

    public function gallery(){
      $gallerys = Gallery::orderBy('id', 'desc')->where('delete_status', '0')->get();
      return view('frontend.gallery', compact('gallerys'));
    }

    public function blog(){
        $blogs = Blog::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->paginate(9);
        return view('frontend.blog', compact('blogs',), ['page_title' => 'Blogs']);
    }

    public function shownewsroom($slug){
        $newsrooms = NewsRoom::where('slug', $slug)->orderBy('id','desc')->where('delete_status','0')->first();
        $related = NewsRoom::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->take(6)->get();
        return view('frontend.view-newsroom', compact('newsrooms','related'), ['page_title' => 'News Room']);
    }

    public function newsroom(){
        $newsrooms = NewsRoom::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->paginate(9);
        return view('frontend.newsroom', compact('newsrooms',), ['page_title' => 'News Room']);
    }

    public function showblog($slug){
        $blogs = Blog::where('slug', $slug)->orderBy('id','desc')->where('delete_status','0')->first();
        $related = Blog::orderBy('id','desc')->where('delete_status','0')->where('status', '1')->take(6)->get();
        return view('frontend.view-blog', compact('blogs','related'), ['page_title' => 'Blog']);
    }

    public function career(){
        $teams = Team::where('delete_status','0')->where('status', '1')->get();
        return view('frontend.career', compact('teams'));
    }

    public function contactus(){
        $setup = WebsiteSetup::orderBy('id','desc')->where('delete_status','0')->first();
        return view('frontend.contact', compact('setup'), ['page_title' => 'Contact Us']);
    }

    public function privacy(){
        $data = Terms::where('delete_status','0')->first();
        return view('frontend.privacy', compact('data'));
    }

    public function terms(){
        $data = Terms::where('delete_status','0')->first();
        return view('frontend.terms', compact('data'));
    }

}
