<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Models\CourseCategory;
use App\Models\SvyscExam;
use Illuminate\Http\Request;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses = Course:: orderBy('id', 'desc')->where('delete_status', '0')->with('category')->get();
        return view('backend.courses.index', compact('courses' ));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category=CourseCategory::where('delete_status','0')->get(['id','course_name']);
		return view('backend.courses.create',['category'=>$category]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $courses=$request->all();

        if($request->file('course_img')){
            $imageName = time().'.'.$request->course_img->extension();
            $request->course_img->move(public_path('backend/images/courses'), $imageName);
            $courses['course_img']=$imageName;
        }


        $courses['slug']=\Str::slug($request->course_name).'-'.rand();
        Course::create($courses);


        return redirect()->route('service.index')
        ->with('success','courses created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Course  $course
     * @return \Illuminate\Http\Response
     */
    public function show(Course $course)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Course  $course
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $courses=Course::find($id);
        $category=CourseCategory::where('delete_status','0')->get(['id','course_name']);
        return view('backend.courses.edit', compact('courses' , 'category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Course  $course
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $courses = Course::find($id);
        $input=$request->all();

        if($request->file('course_img')){
            $imageName = time().'.'.$request->course_img->extension();
            $request->course_img->move(public_path('backend/images/courses'), $imageName);
            $input['course_img']=$imageName;
        }

        $courses->update($input);

        return redirect()->route('service.index')
        ->with('success','Course Updated successfully.');
    }

    public function registration_form_store(Request $request) {

        $this->validate($request,[
         'phone' => 'required|digits:10',
        //  'fathers_phone' => 'required|digits:10',
        ]);
        $cech_number=SvyscExam::where('phone', $request->phone)->get();
        if(count($cech_number)==0){

            $user_details = new SvyscExam;
            //$user_details->user_id = $user->id;
            $user_details->name = $request->name;
            $user_details->gender = $request->gender;
            $user_details->dob = $request->date_of_birth;
            $user_details->phone = $request->phone;
            $user_details->email = $request->email;
            $user_details->dob = $request->date_of_birth;
            $user_details->adhar_number = $request->adhar_number;
            $user_details->p10th_marks = $request->p10th_marks;
            $user_details->passing_year = $request->passing_year;
            $user_details->roll_no = $request->roll_no;
            $user_details->fathers_name = $request->fathers_name;
            $user_details->mother_name = $request->mother_name;
            $user_details->fathers_phone = $request->fathers_phone;
            $user_details->pincode = $request->pincode;
            $user_details->country = $request->country;
            $user_details->state = $request->state;
            $user_details->district = $request->district;
            $user_details->address = $request->address;
            $user_details->which_class = $request->which_class;
            $user_details->school_name = $request->school_name;
            $user_details->education_board = $request->education_board;
            $user_details->career_choice = $request->career_choice;
            //$user_details->otp_verify_status = $request->otp_verify_status;
            $user_details->save();
            return redirect()->back()->with('success','Form Inserted Successfully.');
             Msg91::sms()->to('91'.$request->phone)->flow('626becbee00d0735352fabb4')->variable('user', $request->name)->variable('exam', 'National Science Scholarship Test')->variable('link', 'https://tinyurl.com/mpre25yu')->send();

            if(count(User::where('phone',$request->phone)->get())==0){
                $request->request->add(['password' => $request->phone]);
                 $registerController = new RegisterController;
                 $registerController->register($request);
                 return redirect()->route('verification');
            }

        }else{
            return redirect()->back()->with('error','This Phone Number Already Registered.');
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Course  $course
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $courses= Course::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('service.index')
                        ->with('success','Course deleted successfully');
    }


}
