<?php

namespace App\Http\Controllers;

use App\Models\College;
use Illuminate\Http\Request;

class CollegeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $colleges = College::OrderBy('id', 'desc')->where('delete_status','0')->get();
        return view('backend.colleges.index', compact('colleges'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $college=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/colleges'), $imageName);
            $college['image']=$imageName;
        }

         //$college['slug']=\Str::slug($request->name).'-'.rand();
         College::create($college);

         return redirect()->route('college.index') ->with('success','College Updated successfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function show(College $college)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $college=College::find($id);
        $colleges = College::orderBy('id', 'desc')->where('delete_status','0')->get();
        return view('backend.colleges.index', compact('college', 'colleges' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $college = College::find($id);
        $input=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/colleges'), $imageName);
            $input['image']=$imageName;
        }

        $college->update($input);

        return redirect()->route('college.index')->with('success','College Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $college= College::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('college.index')->with('success','College deleted successfully');
    }
}
