<?php

namespace App\Http\Controllers;

use App\Models\Career;
use Illuminate\Http\Request;

class CareerController extends Controller
{
    public function index()
    {
        $career = Career::where('delete_status','0')->latest()->get();
        return view('backend.career.index', compact('career'));
    }

    public function store(Request $request)
    {
        $validation = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'number' => 'required',
            'qualification' => 'required',
            'address' => 'required',
        ]);

        $career = new Career;
        $career->name = $request->name;
        $career->email = $request->email;
        $career->number = $request->number;
        $career->qualification = $request->qualification;
        $career->address = $request->address;
        $career->message = $request->message;
        $career->save();
        return back()->with('success','Application Send Successfully');
    }

    public function destroy($id)
    {
        $career = Career::where('id', $id)->update(array('delete_status' => 1));
        return back()->with('success','Application Deleted Successfully');
    }
}
