<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $blogs = Blog::orderBy('id','desc')->where('delete_status','0')->paginate(10);
        return view('backend/blog.index', compact('blogs') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend/blog.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
        ]);

        $blog=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/blog'), $imageName);
            $blog['image']=$imageName;
        }


        $blog['slug']=\Str::slug($request->title).'-'.rand();
        Blog::create($blog);


        return redirect()->route('blog.index')
        ->with('success','Blog created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(Blog $blog)
    {
        return view('backend/blog.edit',compact('blog'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $blog = Blog::find($id);
        $input=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/blog'), $imageName);
            $input['image']=$imageName;
        }

        $blog->update($input);


        return redirect()->route('blog.index')->with('success','Blog updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $blog= blog::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('blog.index')
                        ->with('success','Blog deleted successfully');
    }

    public function changeStatus(Request $request)

    {
        $blog = Blog::find($request->id);
        $blog->status = $request->status;
        $blog->save();

        return response()->json(['success'=>'Status change successfully.']);
    }
}
