<?php

namespace App\Http\Controllers;

use App\Models\About;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $aboutpage = About:: Where('delete_status', '0')->first();
        return view('backend.about.index', compact('aboutpage') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $aboutpage=$request->all();

        if($request->file('about_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->about_image->extension();
            $request->about_image->move(public_path('backend/images/about'), $imageName);
            $aboutpage['about_image']=$imageName;
        }

        if($request->file('mission_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->mission_image->extension();
            $request->mission_image->move(public_path('backend/images/about'), $imageName);
            $aboutpage['mission_image']=$imageName;
        }

        if($request->file('vision_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->vision_image->extension();
            $request->vision_image->move(public_path('backend/images/about'), $imageName);
            $aboutpage['vision_image']=$imageName;
        }

        if($request->file('value_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->value_image->extension();
            $request->value_image->move(public_path('backend/images/about'), $imageName);
            $aboutpage['value_image']=$imageName;
        }

        // $blog['slug']=\Str::slug($request->title).'-'.rand();
        About::create($aboutpage);


        return redirect()->route('aboutpage.index')
        ->with('success','About Updated successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(About $aboutpage)
    {
        return view('backend.about.index',compact('aboutpage'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $aboutpage = About::find($id);
        $input=$request->all();

        if($request->file('about_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->about_image->extension();
            $request->about_image->move(public_path('backend/images/about'), $imageName);
            $input['about_image']=$imageName;
        }

        if($request->file('mission_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->mission_image->extension();
            $request->mission_image->move(public_path('backend/images/about'), $imageName);
            $input['mission_image']=$imageName;
        }

        if($request->file('vision_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->vision_image->extension();
            $request->vision_image->move(public_path('backend/images/about'), $imageName);
            $input['vision_image']=$imageName;
        }

        if($request->file('value_image')){
            $imageName = rand(111, 999).'-'.rand(111, 999).'-'.time().'.'.$request->value_image->extension();
            $request->value_image->move(public_path('backend/images/about'), $imageName);
            $input['value_image']=$imageName;
        }


        $aboutpage->update($input);

        return redirect()->route('aboutpage.index')
        ->with('success','Aboutpage updated successfully.');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

    }
}
